% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive_ace.r
\name{naive_ace}
\alias{naive_ace}
\title{Extract the information from the simulation data frame to analyse the naive causal effects}
\usage{
naive_ace(allsim, dataset, exposures, delta = c(0, 1), ic_dis = "IC",
  st)
}
\arguments{
\item{allsim}{dataset with all simulations values}

\item{dataset}{dataset with all variables}

\item{exposures}{a vector with exposures}

\item{delta}{a vector with two values}

\item{ic_dis}{choose between ic (interval confidences) and dis (distribution)}

\item{st}{summary table from general function}
}
\value{
a data frame with naive ace and confident intervals
}
\description{
Extract the information from the simulation data frame to analyse the naive causal effects
}
\examples{
data(expose_data)
data(simu)
data(gen)
delta=c(1,0)
Exposures<- c('Var1','Var2','Var3','Var4','Var5')
summary_table_lines <- gen[[2]]
ace.df.g <- naive_ace (allsim = simu[[1]], dataset = expose_data,
ic_dis = 'IC', st = summary_table_lines,
exposures = Exposures, delta = delta)
}
