% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph2bitmap.R
\name{graph2bitmap}
\alias{graph2bitmap}
\alias{graph2png}
\alias{graph2tif}
\alias{graph2jpg}
\alias{graph2png}
\alias{graph2tif}
\alias{graph2jpg}
\title{Save currently active R graph to bitmap format}
\usage{
graph2bitmap(x = NULL, file = "Rplot", fun = NULL, type = c("PNG",
  "JPG", "TIF"), aspectr = NULL, width = NULL, height = NULL, dpi = 300,
  scaling = 100, font = ifelse(Sys.info()["sysname"] == "Windows", "Arial",
  "Helvetica")[[1]], bg = "white", cairo = TRUE,
  tiffcompression = c("lzw", "rle", "jpeg", "zip", "lzw+p", "zip+p"),
  jpegquality = 99, ...)

graph2png(...)

graph2tif(...)

graph2jpg(...)
}
\arguments{
\item{x}{given \code{ggplot2} plot or \code{lattice} plot object to export; if
set to \code{NULL} the currently active R graph will be exported; not
supported for base R plots.}

\item{file}{name of output file. Any extension is ignored and added
according to the requested output type. If file already exists it is overwritten.}

\item{fun}{plot passed on as a function used to create it; useful especially
for base R plots.}

\item{type}{desired output type - \code{PNG}, \code{TIF} or \code{JPG} are currently supported.
\code{PNG} is the preferred format, as it is a lossless format, and compresses better
than \code{TIF}.}

\item{aspectr}{desired width to height aspect ratio. If set to \code{NULL}, the
aspect ratio of the graphics device is used. Can also be combined with one
value for either the desired width or height of the graph.}

\item{width}{desired width in inches; can be combined with a desired
aspect ratio aspectr.}

\item{height}{desired height in inches; can be combined with a desired
aspect ratio aspectr.}

\item{dpi}{desired output in dpi; defaults to 600 dpi.}

\item{scaling}{scale width & height by a certain percentage.}

\item{font}{desired font to use for labels in PNG and TIFF output; defaults to 
\code{"Arial"} on Windows systems and to \code{"Helvetica"} on other systems.}

\item{bg}{desired background colour, e.g. \code{"white"} or \code{"transparent"}.}

\item{cairo}{logical, specifying whether or not to use \code{Cairographics} for export.}

\item{tiffcompression}{compression to use for \code{TIF} files.}

\item{jpegquality}{quality of \code{JPEG} compression.}

\item{\dots}{any other options are passed on to \code{grDevices}' \code{\link[grDevices]{png}}, 
\code{\link[grDevices]{tiff}}, or \code{\link[grDevices]{jpeg}} function (according to the supplied \code{type}).}
}
\value{
\code{NULL}
}
\description{
Save the currently active R graph or a graph passed as an object or function 
to bitmap format with sensible defaults
}
\section{Functions}{
\itemize{
\item \code{graph2png}: Save currently active R graph to png file

\item \code{graph2tif}: Save currently active R graph to TIF file

\item \code{graph2jpg}: Save currently active R graph to JPEG file
}}

\examples{
# Create a file name
filen <- tempfile(pattern = "ggplot") # or 
# filen <- paste("YOUR_DIR/ggplot")

# Generate graphical output
library(ggplot2)
library(datasets)
x=qplot(Sepal.Length, Petal.Length, data = iris, 
        color = Species, size = Petal.Width, alpha = I(0.7))
plot.fun <- function(){
  print(qplot(Sepal.Length, Petal.Length, data = iris, 
              color = Species, size = Petal.Width, alpha = 0.7))
}

# There are 3 ways to use graph2bitmap():
### 1. Pass the plot as an object
graph2png(x=x, file=filen, dpi=400, height = 5, aspectr=4)
graph2tif(x=x, file=filen, dpi=400, height = 5, aspectr=4)
graph2jpg(x=x, file=filen, dpi=400, height = 5, aspectr=4) 
### 2. Get the plot from current screen device
\donttest{ # Because the example uses screen devices 
  x
  graph2png(file=filen, dpi=400, height = 5, aspectr=4)
  graph2tif(file=filen, dpi=400, height = 5, aspectr=4)
  graph2jpg(file=filen, dpi=400, height = 5, aspectr=4) 
}
### 3. Pass the plot as a function
\donttest{ # Because the example uses screen devices 
  graph2png(file=filen, fun=plot.fun, dpi=400, height = 5, aspectr=4)
  graph2tif(file=filen, fun=plot.fun, dpi=400, height = 5, aspectr=4)
  graph2jpg(file=filen, fun=plot.fun, dpi=400, height = 5, aspectr=4)
} 
}
\seealso{
\code{\link{graph2office}}, \code{\link{graph2vector}}, \code{\link{graph2svg}}, \code{\link{graph2pdf}},
\code{\link{graph2eps}}
}
\author{
Tom Wenseleers
}
