% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exdex-package.R
\docType{data}
\name{uccle720}
\alias{uccle720}
\title{20th century Uccle maximum daily temperatures in July - data frame}
\format{
A data frame with 3100 observations on the following and 5
  variables.
\itemize{
\item{\code{temp:}}{ daily maximum temperature in degrees C.}
\item{\code{year:}}{ the year.}
\item{\code{month:}}{ the month of the year.}
\item{\code{day:}}{ day of the month.}
\item{\code{date:}}{ date with the \code{\link[base:Dates]{Date}} class,
  in the format YYYY-MM-DD.}
}
}
\source{
Klein Tank, A.M.G. and Coauthors, 2002. Daily dataset of
 20th-century surface air temperature and precipitation series for the
 European Climate Assessment. \emph{Int. J. of Climatol.}, \strong{22},
 1441-1453 \doi{10.1002/joc.773}. Data and metadata available at
 \href{https://www.ecad.eu}{https://www.ecad.eu}.  The data were downloaded
 on 27/3/2022 using a
 \href{https://www.ecad.eu/dailydata/customquery.php}{Custom query (ASCII)},
 selecting "non-blend" for type of series.
}
\usage{
uccle720
}
\description{
The dataframe \code{uccle720} contains daily maximum temperatures in degrees C
recorded at the Uccle, Belgium during July for the years 1901 to 1999.
The Station identifier in the source file is 17 and the Source identifier is
117882.  These data are analysed in Holesovsky and Fusek (2020).
}
\note{
There are 6 missing values, one located in each of the years
  1925, 1926, 1956, 1963, 1969 and 1976.
}
\examples{
uccle720_ts <- ts(uccle720$temp, start = c(1901, 1), frequency = 31)
plot(uccle720_ts, ylab = "daily maximum temperature in July / degrees C",
     xlab = "year")
}
\references{
Holesovsky, J. and Fusek, M. Estimation of the extremal index
  using censored distributions. \emph{Extremes}, \strong{23}, 197-213
  (2020). \doi{10.1007/s10687-020-00374-3}
}
\keyword{datasets}
