% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location.R
\name{mark_location}
\alias{mark_location}
\title{Mark locations outside of US}
\usage{
mark_location(
  x,
  id_col = "ResponseId",
  location_col = c("LocationLatitude", "LocationLongitude"),
  rename = TRUE,
  include_na = FALSE,
  quiet = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{location_col}{Two element vector specifying columns for latitude
and longitude (in that order).}

\item{rename}{Logical indicating whether to rename columns (using \code{\link[=rename_columns]{rename_columns()}})}

\item{include_na}{Logical indicating whether to include rows with NA in
latitude and longitude columns in the output list of potentially excluded
data.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}
}
\value{
An object of the same type as \code{x} that includes a column marking rows
that are located outside of the US and (if \code{include_na == FALSE}) rows with
no location information.
For a function that checks for these rows, use \code{\link[=check_location]{check_location()}}.
For a function that excludes these rows, use \code{\link[=exclude_location]{exclude_location()}}.
}
\description{
The \code{mark_location()} function creates a column labeling
rows that have locations outside of the US.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
To record this information in your Qualtrics survey, you must ensure that
\href{https://www.qualtrics.com/support/survey-platform/survey-module/survey-options/survey-protection/#AnonymizingResponses}{Anonymize responses is disabled}.

Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
The function only works for the United States.
It uses the #' \code{\link[maps:map.where]{maps::map.where()}} to determine if latitude and longitude
are inside the US.

The function outputs to console a message about the number of rows
with locations outside of the US.
}
\examples{
# Mark locations outside of the US
data(qualtrics_text)
df <- mark_location(qualtrics_text)

# Remove preview data first
df <- qualtrics_text \%>\%
  exclude_preview() \%>\%
  mark_location()
}
\seealso{
Other location functions: 
\code{\link{check_location}()},
\code{\link{exclude_location}()}

Other mark functions: 
\code{\link{mark_duplicates}()},
\code{\link{mark_duration}()},
\code{\link{mark_ip}()},
\code{\link{mark_preview}()},
\code{\link{mark_progress}()},
\code{\link{mark_resolution}()}
}
\concept{location functions}
\concept{mark functions}
