% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exams2mylearn.R
\name{exams2mylearn}
\alias{exams2mylearn}
\title{Exam Generation for the 'MyLearn' Platform}
\usage{
exams2mylearn(
  filename,
  n,
  dir,
  tdir = NULL,
  name = NULL,
  outfile = NULL,
  dontask = !base::interactive(),
  distort.shortname = FALSE,
  ...
)
}
\arguments{
\item{filename}{(character) absolute or relative path to the exercise template.
Usually simply a file name pointing at a .Rmd file in the working directory}

\item{n}{(integer) number of random variants to create}

\item{dir}{(character) output directory, will be created if non-existent}

\item{tdir}{(character, \emph{optional}) temporary directory; will use \code{tempdir()} if unspecified}

\item{name}{(character, \emph{optional}) unique name prefix of temporary and output files,
defaults to \code{filename} without the non-alphabetic characters}

\item{outfile}{(character, \emph{optional}) output file name (not a path), defaults to \code{name}.zip}

\item{dontask}{(logical, \emph{optional}) if \code{TRUE} and the output zip file exists then}

\item{distort.shortname}{(logical, \emph{optional}) should the shortname include a random ending?
Defaults to \code{FALSE}}

\item{...}{forwarded to \code{exams2html}}
}
\value{
If \code{dir} is invalid or unspecified, the function returns with an error.
Otherwise the function produces a zip file in directory \code{dir}.
The exact path to the zip file is returned invisibly.
}
\description{
The 'MyLearn' distance learning and teaching platform has a special XML format.
\code{exams2mylearn} transforms
input files in the R/exams format to XML files and zips them. The resulting
zip file can be directly uploaded to the 'MyLearn' platform.
}
\note{
The development team has to turn on the upload functionality on
a per course basis.
}
\examples{

# Get the examples provided with the package
ex_files <- example_paths()
if (interactive()) {
  # Produce 40 exam questions in the currect directory
  #   using the example that contains a plot; the
  #   output is "final_exam.zip", and we want to
  #   distort the shortname used by 'MyLearn'
  exams2mylearn(ex_files["plot"], 40, dir = ".",
                outfile = "final_exam_question_1.zip",
                distort.shortname = TRUE)
}

# Takes some time:
\dontrun{
# Produce 500 exam questions in the current
#   directory using a different example with more
#   verbose output from exams::exams2html
exams2mylearn(ex_files["single_choice"], 500,
              dir = ".", name = "final_exam_question_1",
              verbose = TRUE)
}
}
