% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhyloMantel.R
\name{PhyloMantel}
\alias{PhyloMantel}
\title{Mantel test with phylogenetic permutations}
\usage{
PhyloMantel(
  tree,
  matrix.1,
  matrix.2,
  ...,
  permutations = 1000,
  ComparisonFunc = function(x, y) cor(x[lower.tri(x)], y[lower.tri(y)]),
  k = 1
)
}
\arguments{
\item{tree}{phylogenetic tree. Tip labels must match names in input matrices}

\item{matrix.1}{pair-wise comparison/distance matrix}

\item{matrix.2}{pair-wise comparison/distance matrix}

\item{...}{aditional parameters, currently ignored}

\item{permutations}{Number of permutations used in significance calculation}

\item{ComparisonFunc}{comparison function, default is MatrixCor}

\item{k}{determines the influence of the phylogeny. 1 is strong influence, and larger values converge to a traditional mantel test.}
}
\value{
returns a vector with the comparison value and the proportion of times the observed comparison is smaller than the correlations from the permutations.
}
\description{
Performs a matrix correlation with significance given by a phylogenetic Mantel Test. 
Pairs of rowns and columns are permuted with probability proportional to their phylogenetic distance.
}
\note{
This method should only be used when there is no option other than representing data as pair-wise. It suffers from low power, and alternatives should be used when available.
}
\examples{
data(dentus)
data(dentus.tree)
tree = dentus.tree
cor.matrices = dlply(dentus, .(species), function(x) cor(x[-5]))
comparisons = MatrixCor(cor.matrices)

sp.means = dlply(dentus, .(species), function(x) colMeans(x[-5]))
mh.dist = MultiMahalanobis(means = sp.means, cov.matrix = PhyloW(dentus.tree, cor.matrices)$'6')
PhyloMantel(dentus.tree, comparisons, mh.dist, k = 10000)

#similar to MantelCor for large k:
\dontrun{
PhyloMantel(dentus.tree, comparisons, mh.dist, k = 10000)
MantelCor(comparisons, mh.dist)
}
}
\references{
Harmon, L. J., & Glor, R. E. (2010). Poor statistical performance of the Mantel test in phylogenetic comparative analyses. Evolution, 64(7), 2173-2178.

Lapointe, F. J., & Garland, Jr, T. (2001). A generalized permutation model for the analysis of cross-species data. Journal of Classification, 18(1), 109-127.
}
\author{
Diogo Melo, adapted from Harmon & Glor 2010
}
