% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearParsimony.R
\name{LinearParsimony}
\alias{LinearParsimony}
\title{Estimation of Linear Parcimony ancestral stated for multivariate continous traits}
\usage{
LinearParsimony(tree, tip_means, ...)
}
\arguments{
\item{tree}{phylogenetic tree}

\item{tip_means}{list of tip nodes data. Expects one vector for each terminal.}

\item{...}{aditional arguments for phytools::fastAnc}
}
\value{
list with calculated ancestral states, using labels or numbers from tree
}
\description{
Wagner optimization
}
\examples{

data(dentus)
data(dentus.tree)
mean.list <- dlply(dentus, .(species), numcolwise(mean))
names(mean.list) <- dentus.tree$tip.label
evolqg:::LinearParsimony(dentus.tree, mean.list)
}

