% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.multi.OU.R
\name{sim.multi.OU}
\alias{sim.multi.OU}
\title{Simulate multivariate Ornstein-Uhlenbeck evolutionary sequence data sets}
\usage{
sim.multi.OU(
  ns = 30,
  anc = c(0, 0),
  optima = c(3, 2),
  A = matrix(c(7, 0, 0, 6), nrow = 2, byrow = TRUE),
  R = matrix(c(0.05, 0, 0, 0.05), nrow = 2, byrow = TRUE),
  vp = 0.1,
  nn = rep(30, ns),
  tt = 0:(ns - 1)
)
}
\arguments{
\item{ns}{number of samples in time-series}

\item{anc}{the ancestral trait values}

\item{optima}{the optimal trait values}

\item{A}{the pull matrix.}

\item{R}{the drift matrix}

\item{vp}{within-population trait variance}

\item{nn}{vector of the number of individuals in each sample (identical sample sizes for all time-series is assumed)}

\item{tt}{vector of sample ages, increases from oldest to youngest}
}
\value{
A multivariate evolutionary sequence (time-series) data set.
}
\description{
Function to simulate a multivariate Ornstein-Uhlenbeck evolutionary sequence data set.
}
\note{
The Ornstein Uhlenbeck model is reduced to an Unbiased Random Walk when the alpha parameter is zero. It is therefore possible to let a trait evolve as an Unbiased Random Walk by setting the diagonal element for that trait to a value close to zero (e.g. 1e-07). Elements in the diagonal of A cannot be exactly zero as this will result in a singular variance-covariance matrix.
}
\examples{
##Define the A and R matrices

A_matrix<-matrix(c(4,-2,0,3), nrow=2, byrow = TRUE)
R_matrix<-matrix(c(4,0.2,0.2,4), nrow=2, byrow = TRUE)

## Generate an evoTS object by simulating a multivariate dataset
data_set<-sim.multi.OU(40, optima = c(1.5,2),A=A_matrix , R = R_matrix)

## plot the data
plotevoTS.multivariate(data_set)

}
\author{
Kjetil Lysne Voje
}
