% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logl.joint.multi.OUOU.user.R
\name{logL.joint.multi.OUOU.user}
\alias{logL.joint.multi.OUOU.user}
\title{Log-likelihoods for evolutionary models}
\usage{
logL.joint.multi.OUOU.user(
  init.par,
  yy,
  A.user,
  R.user,
  locations.A,
  location.diag.A,
  location.upper.tri.A,
  location.lower.tri.A,
  locations.R,
  location.diag.R,
  location.upper.tri.R
)
}
\arguments{
\item{init.par}{initial (starting) parameters values}

\item{yy}{a multivariate evoTS object}

\item{A.user}{the pull matrix.}

\item{R.user}{the drift matrix.}

\item{locations.A}{location (row and column) of parameters (elements) in the A matrix that is estimated}

\item{location.diag.A}{location (row and column) of parameters (elements) in the diagonal of the A matrix that is estimated}

\item{location.upper.tri.A}{location (row and column) of parameters (elements) in the upper triangle of the A matrix that is estimated}

\item{location.lower.tri.A}{location (row and column) of parameters (elements) in the lower triangle of the A matrix that is estimated}

\item{locations.R}{location (row and column) of parameters (elements) in the R matrix that is estimated}

\item{location.diag.R}{location (row and column) of parameters (elements) in the diagonal of the R matrix that is estimated}

\item{location.upper.tri.R}{location (row and column) of parameters (elements) in the upper triangle of the R matrix that is estimated}
}
\value{
The log-likelihood of the parameter estimates, given the data.
}
\description{
Returns log-likelihood for a multivariate Ornstein-Uhlenbeck model with used defined A and R matrices..
}
\details{
In general, users will not be access these functions directly, but instead use the optimization functions, which use these functions to find the best-supported parameter values.
}
\author{
Kjetil Lysne Voje
}
