% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event.R
\name{new_event}
\alias{new_event}
\alias{validate_event}
\alias{event}
\title{Event Constructor}
\usage{
new_event(id = uuid::UUIDgenerate(), type, time = Sys.time(), ...)

validate_event(id, type, time, ...)

event(id = uuid::UUIDgenerate(), type, time, ...)
}
\arguments{
\item{id}{A character identifier}

\item{type}{A character indicating the event type}

\item{time}{A character string indicating the event timestamp}

\item{...}{A list with the event attributes.}
}
\value{
The function returns an object of class \code{event}. \code{event}
objects are implemented as a list of two main elements: A \code{head} and
a \code{body}.The \code{head} contains an identifier (\code{id}), a string
indicating the event type (\code{type}) and a \code{POSIXct} object indicating
when the event occurs (\code{time}). The \code{body} containts the event attributes
defined by the user. By default \code{id} is generated using \pkg{uuid} and \code{time}
value is the result of \code{Sys.time()} function by default.
}
\description{
Event constructor
}
\examples{

birth_event <- event(
  id = 'first-id',
  type = 'BIRTH',
  time = '1936-11-09',
  birth_date = '1936-11-09'
)

death_event <- event(
  id = 'second-id',
  type = 'DEATH',
  time = '2019-05-22',
  death_date = '2019-05-22'
)

}
