% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.r
\name{estimate_hte}
\alias{estimate_hte}
\title{Evaluate Heterogeneous Treatment Effects}
\usage{
estimate_hte(
  treatment,
  form,
  data,
  algorithms,
  n_folds = 5,
  split_ratio = 0,
  ngates = 5,
  preProcess = NULL,
  weights = NULL,
  trControl = caret::trainControl(method = "none"),
  tuneGrid = NULL,
  tuneLength = ifelse(trControl$method == "none", 1, 3),
  user_model = NULL,
  SL_library = NULL,
  meta_learner = "slearner",
  ...
)
}
\arguments{
\item{treatment}{Treatment variable}

\item{form}{a formula object that takes the form \code{y ~ D + x1 + x2 + ...}.}

\item{data}{A data frame that contains the outcome \code{y} and the treatment \code{D}.}

\item{algorithms}{List of machine learning algorithms to be used.}

\item{n_folds}{Number of cross-validation folds. Default is 5.}

\item{split_ratio}{Split ratio between train and test set under sample splitting. Default is 0.}

\item{ngates}{The number of groups to separate the data into. The groups are determined by tau. Default is 5.}

\item{preProcess}{caret parameter}

\item{weights}{caret parameter}

\item{trControl}{caret parameter}

\item{tuneGrid}{caret parameter}

\item{tuneLength}{caret parameter}

\item{user_model}{A user-defined function to estimate heterogeneous treatment effects.}

\item{SL_library}{A list of machine learning algorithms to be used in the super learner.}

\item{meta_learner}{The type of meta-learner to use (e.g., "slearner", "tlearner"). Default is "slearner".}

\item{...}{Additional arguments passed to \code{caret::train}.}
}
\value{
An object of \code{hte} class
}
\description{
Evaluate Heterogeneous Treatment Effects
}
