% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{stat}
\alias{stat}
\title{Calculate evaluation statistics from numerical vectors}
\usage{
stat(
  model,
  observation,
  wd = FALSE,
  cutoff = NA,
  cutoff_NME = NA,
  nobs = 8,
  rname,
  verbose = TRUE
)
}
\arguments{
\item{model}{numeric vector with paired model data}

\item{observation}{numeric vector with paired observation data}

\item{wd}{logical, set true to apply a rotation on wind direction, see notes}

\item{cutoff}{(optionally the maximum) valid value for observation}

\item{cutoff_NME}{(optionally the maximum) valid value for observation for NME, MFB and MFE}

\item{nobs}{minimum number of observations}

\item{rname}{row name}

\item{verbose}{display additional information}
}
\value{
data.frame with calculated Number of pairs, observation average, model average, correlation, Index Of Agreement, Factor of 2, Root Mean Square Error, Mean Bias, Mean error, Normalized Mean Bias, and Normalized Mean Bias
}
\description{
Calculate statistical indexes (Number of pairs, observation average, model average, correlation, Index Of Agreement, Factor of 2, Root Mean Square Error, Mean Bias, Mean error, Normalized Mean Bias, and Normalized Mean Bias) for model evaluation
}
\note{
the option wd = TRUE applies a rotation of 360 on model wind direction to minimize the angular difference.
}
\examples{
model <- 1:100
data  <- model + rnorm(100,0.2)
stat(model = model, observation = data)

}
\references{
Emery, C. and Tai., E. 2001. Enhanced Meteorological Modeling and Performance Evaluation
for Two Texas Ozone Episodes.

Monk, K. et al. 2019. Evaluation of Regional Air Quality Models over Sydney and Australia:
Part 1—Meteorological Model Comparison. Atmosphere 10(7), p. 374. doi: 10.3390/atmos10070374.

Ramboll. 2018. PacWest Newport Meteorological Performance Evaluation.

Zhang, Y. et al. 2019. Multiscale Applications of Two Online-Coupled Meteorology-Chemistry
Models during Recent Field Campaigns in Australia, Part I: Model Description and WRF/Chem-ROMS
Evaluation Using Surface and Satellite Data and Sensitivity to Spatial Grid Resolutions.
Atmosphere 10(4), p. 189. doi: 10.3390/atmos10040189.

Emery, C., Liu, Z., Russell, A.G., Odman, M.T., Yarwood, G. and Kumar, N. 2017.
Recommendations on statistics and benchmarks to assess photochemical model performance.
Journal of the Air & Waste Management Association 67(5), pp. 582–598.
doi: 10.1080/10962247.2016.1265027.

Zhai, H., Huang, L., Emery, C., Zhang, X., Wang, Y., Yarwood, G., ... & Li, L. (2024).
Recommendations on benchmarks for photochemical air quality model applications
in China—NO2, SO2, CO and PM10. Atmospheric Environment, 319, 120290.
}
