% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_latent_trawl.R
\name{TrfG}
\alias{TrfG}
\title{Computes g from the marginal transform method (vectorised version).
That is from GPD(alpha, beta+kappa) to GPD(offset_shape, offset_scale).}
\usage{
TrfG(x, alpha, beta, kappa, offset_scale, offset_shape)
}
\arguments{
\item{x}{Data distributed as GPD(offset_shape, offset_scale).}

\item{alpha}{Shape parameter of output data.}

\item{beta}{Part of scale parameter of output data (beta + kappa).
Should be positive.}

\item{kappa}{Part of scale parameter of output data.
Should be positive.}

\item{offset_scale}{Scale parameter of input data.
Should be positive.}

\item{offset_shape}{Shape parameter of input data.}
}
\value{
GPD(offset_shape, offset_scale)-distributed data from
GPD(alpha, beta+kappa)-distributed data input data.
}
\description{
Computes g from the marginal transform method (vectorised version).
That is from GPD(alpha, beta+kappa) to GPD(offset_shape, offset_scale).
}
