% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_latent_trawl.R
\name{SinglePairPL}
\alias{SinglePairPL}
\title{Computes correct latent trawl SINGLE pairwise likelihood depending on the
values of \code{(x1,x2)} with exponential trawl function.}
\usage{
SinglePairPL(x1, x2, alpha, beta, kappa, B1, B2, B3, transformation = F,
  n.moments = 0)
}
\arguments{
\item{x1}{Positive value corresponding to \code{t1}.}

\item{x2}{Positive value corresponding to \code{t2}.}

\item{alpha}{Shape parameter. Should be positive.}

\item{beta}{Latent Gamma scale parameter. Should be positive.}

\item{kappa}{Exceedance probability parameter. Should be positive.}

\item{B1}{Difference area between \code{t1} and \code{t2} (in this order).}

\item{B2}{Intersection area between \code{t1} and \code{t2} (in this order).}

\item{B3}{Difference area between \code{t2} and \code{t1} (in this order).}

\item{transformation}{Boolean to use the Marginal Transform (MT) method.}

\item{n.moments}{Number of finite moments for transformed marginals.}
}
\value{
SINGLE latent trawl pairwise likelihood depending on \code{(x1,x2)}.
}
\description{
Computes correct latent trawl SINGLE pairwise likelihood depending on the
values of \code{(x1,x2)} with exponential trawl function.
}
\examples{
SinglePairPL(x1=0.5, x2= 0.3, alpha=0.3, beta=2, kappa=3, B1=0.3, B2=0.7, B3=0.3, FALSE)
SinglePairPL(x1=2.0, x2=1.0, alpha=-2, beta=3., kappa=3,  B1=0.3, B2=0.7, B3=0.3, TRUE)

}
