% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medianheuristic.R
\name{medianheuristic}
\alias{medianheuristic}
\title{Compute the median heuristic}
\usage{
medianheuristic(X, Y = NULL, kernel = c("Laplacian", "Gaussian"), fast = FALSE)
}
\arguments{
\item{X}{Numeric vector or matrix of length \code{n}.}

\item{Y}{Numeric vector or matrix of length \code{m}, or \code{NULL}.}

\item{kernel}{String, either \code{"Laplacian"} or \code{"Gaussian"}.}

\item{fast}{Boolean; if \code{TRUE} will run \code{O(N log N)} algorithm,
where \code{N = n + m},
but if \code{FALSE} will run naive \code{O(N^2 log(N))} algorithm.}
}
\value{
a scalar, the inverse of the median of all pairwise differences.
}
\description{
Computes the inverse of the median difference out of all differences
between distinct pairs in vectors or matrices.
}
\details{
Computes median of differences \code{md} using \code{mediandiff}
and then returns \code{1 / md}.
}
\examples{

X <- c(7.1, 1.2, 4.3, 0.4)
Y <- c(5.5, 2.6, 8.7)
mh <- medianheuristic(X, Y, kernel="Laplacian", fast=TRUE)


}
\seealso{
mediandiff
}
