% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_generics.R, R/02_Beta.R, R/02_Dirichlet.R,
%   R/02_Gammad.R, R/02_MGamma.R
\name{avar_same}
\alias{avar_same}
\alias{avar_same,Beta-method}
\alias{avar_same,Dirichlet-method}
\alias{avar_same,Gammad-method}
\alias{avar_same,MGamma-method}
\title{SAME Asymptotic Variance}
\usage{
avar_same(distr, ...)

\S4method{avar_same}{Beta}(distr)

\S4method{avar_same}{Dirichlet}(distr, comp = FALSE)

\S4method{avar_same}{Gammad}(distr)

\S4method{avar_same}{MGamma}(distr, dirich = FALSE)
}
\arguments{
\item{distr}{A subclass of \code{Distribution}. The distribution family assumed.}

\item{...}{extra arguments.}

\item{comp}{logical. Should the component matrices A, B be returned instead?
This argument is used internally by the \code{avar_same} method for the
Multivariate Gamma Dirichlet-based SAME that needs these matrices.}

\item{dirich}{logical. Should the Dirichlet-based estimator be calculated
instead? Applies only to the Multivariate Gamma distribution.}
}
\value{
A named matrix. The asymptotic covariance matrix of the estimator.
}
\description{
Calculates the asymptotic variance (or variance - covariance matrix in the
multidimensional case) of the SAME, given a specified family of
distributions and the true parameter values.
}
\examples{
# -------------------------------------------
# Beta Distribution Example
# -------------------------------------------

# Simulation
set.seed(1)
shape1 <- 1
shape2 <- 2
x <- rbeta(100, shape1, shape2)

library(distr)
D <- Beta(shape1, shape2)

# Likelihood - The ll Functions

llbeta(x, shape1, shape2)
ll(x, c(shape1, shape2), D)
ll(x, c(shape1, shape2), "beta")

# Point Estimation - The e Functions

ebeta(x, type = "mle")
ebeta(x, type = "me")
ebeta(x, type = "same")

mle(x, D)
me(x, D)
same(x, D)

estim(x, D, type = "mle")

# Asymptotic Variance - The v Functions

vbeta(shape1, shape2, type = "mle")
vbeta(shape1, shape2, type = "me")
vbeta(shape1, shape2, type = "same")

avar_mle(D)
avar_me(D)
avar_same(D)

avar(D, type = "mle")
}
\references{
Ye, Z.-S. & Chen, N. (2017), Closed-form estimators for the gamma
distribution derived from likelihood equations, The American Statistician
71(2), 177–181.

Van der Vaart, A. W. (2000), Asymptotic statistics, Vol. 3,
Cambridge university press.

Tamae, H., Irie, K. & Kubokawa, T. (2020), A score-adjusted approach to
closed-form estimators for the gamma and beta distributions, Japanese Journal
of Statistics and Data Science 3, 543–561.

Mathal, A. & Moschopoulos, P. (1992), A form of multivariate gamma
distribution, Annals of the Institute of Statistical Mathematics 44, 97–106.

Oikonomidis, I. & Trevezas, S. (2023), Moment-Type Estimators for the
Dirichlet and the Multivariate Gamma Distributions, arXiv,
https://arxiv.org/abs/2311.15025
}
\seealso{
\link{avar}, \link{avar_mle}, \link{avar_me}
}
