% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_decomp_graphs.R
\name{is_decomposable}
\alias{is_decomposable}
\title{A test for decomposability in undirected graphs}
\usage{
is_decomposable(adj)
}
\arguments{
\item{adj}{Adjacency list of an undirected graph}
}
\value{
Logial describing whether or not \code{adj} is decomposable
}
\description{
This function returns \code{TRUE} if the graph is decomposable and \code{FALSE} otherwise
}
\examples{
# 4-cycle:
adj1 <- list(a = c("b", "d"), b = c("a", "c"), c = c("b", "d"), d = c("a", "c"))
is_decomposable(adj1) # FALSE
# Two triangles:
adj2 <- list(a = c("b", "d"), b = c("a", "c", "d"), c = c("b", "d"), d = c("a", "c", "b"))
is_decomposable(adj2) # TRUE
}
