% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esreg.R
\name{vcovA}
\alias{vcovA}
\title{AsymptotiC Covariance Estimation}
\usage{
vcovA(object, sparsity = "iid", cond_var = "ind",
  bandwidth_type = "Hall-Sheather")
}
\arguments{
\item{object}{An esreg object}

\item{sparsity}{The sparsity estimator,
see \link{density_quantile_function} for more details.
\itemize{
  \item iid - Piecewise linear interpolation of the distribution
  \item nid - Hendricks and Koenker sandwich
}}

\item{cond_var}{The conditional truncated variance estimator,
see \link{conditional_truncated_variance} for more details.
\itemize{
  \item ind - Variance over all negative residuals
  \item scl_N - Scaling with the normal distribution
  \item scl_sp - Scaling with the kernel density function
  }}

\item{bandwidth_type}{The bandwidth estimator
\itemize{
  \item Bofinger
  \item Chamberlain
  \item Hall-Sheather
}}
}
\description{
Estimate the variance-covariance matrix of the joint (VaR, ES) estimator
using the asymptotic formulas
}
