% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_plane.R
\name{display.plane}
\alias{display.plane}
\title{Display the transverse frontal or sagittal view in the patient reference system}
\usage{
display.plane(
  bottom = NULL,
  top = NULL,
  struct = NULL,
  roi.name = NULL,
  roi.sname = NULL,
  roi.idx = NULL,
  struct.dxyz = c(1, 1, 1),
  display.ref = NULL,
  T.MAT = NULL,
  interpolate = TRUE,
  view.type = c("trans", "front", "sagi"),
  view.coord = 0,
  bg = "#000000",
  abs.rng = NULL,
  ord.rng = NULL,
  bottom.col = grey.colors(255, start = 0, end = 1),
  top.col = rainbow(255, s = seq(1, 0, length.out = 255), start = 0, end = 4/6, alpha =
    seq(0.8, 0, length.out = 255), rev = TRUE),
  bottom.breaks = NULL,
  top.breaks = NULL,
  sat.transp = FALSE,
  struct.lwd = 2,
  main = NULL,
  legend.plot = TRUE,
  legend.shift = 0,
  legend.roi.pseudo = TRUE
)
}
\arguments{
\item{bottom}{"volume" class object, displayed using \code{bottom.col}
palette. If \code{bottom = NULL}, no bottom image is displayed.}

\item{top}{"volume" class object, displayed as an overlay, using \code{top.col}
palette. If \code{top = NULL}, no overlay image is displayed.}

\item{struct}{"struct" class object. If \code{NULL}, no RoI is displayed. Only
RoI of closed planar or point type are displayed.}

\item{roi.name}{Vector of exact names of the RoI in the \code{struct} object.
By default \code{roi.name = NULL}. See Details.}

\item{roi.sname}{Vector of names or parts of names of the RoI in the \code{struct}
object. By default \code{roi.sname = NULL}. See Details.}

\item{roi.idx}{Vector of indices of the RoI that belong to the \code{struct}
object. By default \code{roi.idx = NULL}. See Details.}

\item{struct.dxyz}{Vector of 3 numbers. Used in case of \code{bottom} and
\code{top} are set to \code{NULL}. It represents the virtual steps of a temporary
volume created in the \code{display.ref} frame of reference, initialized at 1 mm
in the 3 directions x, y and z.}

\item{display.ref}{Character string. Pseudonym of the frame of reference used
for display. If \code{NULL} (default), the bottom image FoR, or top image FoR
(when no bottom image), or struct FoR (when no volume displayed).}

\item{T.MAT}{"t.mat" class object, created by \link[espadon]{load.patient.from.Rdcm}
or \link[espadon]{load.T.MAT}. If \code{T.MAT} is \code{NULL}, \code{bottom},
\code{top} and \code{struct} must have the same frame of reference.}

\item{interpolate}{Boolean, indicating whether to apply trilinear interpolation
to the \code{bottom} and \code{top} volumes.
If \code{interpolate = FALSE}, the values of the nearest voxels are used. When \code{TRUE} (by delfault),
trilinear interpolation is used.}

\item{view.type}{Character string, defining the view to display. It must be set to
\itemize{
\item \code{"trans"} for a transverse view,
\item \code{"front"} for a frontal view or,
\item \code{"sagi"} for a sagittal view.
}}

\item{view.coord}{Numeric vector of the coordinates along the normal vector of
the selected view.}

\item{bg}{Background color of the image. By default, this color is black.}

\item{abs.rng}{Vector of 2 elements indicating the minimum and maximum abscissa
to display on the background image.}

\item{ord.rng}{Vector of 2 elements indicating the minimum and maximum ordinate
to display on the background image.}

\item{bottom.col, top.col}{Vectors, representing the palette color of
\code{bottom} and \code{top}.}

\item{bottom.breaks, top.breaks}{One of :
\itemize{
\item \code{NULL} : the minimum and the maximum value of \code{bottom} or
\code{top} define the range.
\item Vector giving the breakpoints of each color. Outside values are transparent,
leaving the background visible, depending on \code{sat.transp}.
}
When breaks are specified, the number of breaks must be one unit more then the number of colors.}

\item{sat.transp}{Boolean. If \code{TRUE}, outside values are transparent, else set
to \code{bottom.breaks} or \code{top.breaks} limits.}

\item{struct.lwd}{Line thickness of the RoI contours.}

\item{main}{Character string. When \code{main} different from \code{NULL},
it replaces the title, and removes the subtitle and the maximum dose indication
if \code{top} is of modality rtdose.}

\item{legend.plot}{Boolean, that indicates whether the RoI legend should be
displayed on the image. It is displayed by default.}

\item{legend.shift}{Numeric. It shifts (in mm) the display of the RoI legend
on x-axis.}

\item{legend.roi.pseudo}{Boolean. If \code{TRUE}, the name used
for a RoI in the legend comes from the \code{struct$roi.info$roi.pseudo}
column, otherwise the \code{struct$roi.info$name} column.}
}
\value{
Returns a display of the  transverse, sagittal or frontal plane. This plane
has the coordinate z = view.coord (transverse), y = view.coord (sagittal) pr
x = view.coord (frontal). The display is an overlay of:
\itemize{
\item a background image of uniform color \code{bg}
\item the bottom image if it exists
\item the top image if it exists
\item the contours of the regions of interest if they exist in the plane considered.
}
}
\description{
The \code{display.plane} function displays an overlay of images and RoI
closed planar contours on a plane defined by the equations x = constant (sagittal
view), or y = constant (frontal view) or z = constant (transverse view) in a
frame of reference chosen by the user.
}
\details{
If \code{roi.name}, \code{roi.sname}, and \code{roi.idx} are
all set to \code{NULL}, all closed planar or point RoI are selected.
If a RoI is not present in the requested plane, the RoI legend won't mention it.
}
\note{
1- The main title is given by \code{bottom}, the
subtitle by \code{top}.

2- When \code{top} is in the "rtdose" modality, the maximum dose is
written on the image.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for 
# better result)
step <- 4
patient <- toy.load.patient (modality = c("ct", "mr", "rtstruct", "rtdose"), 
                             roi.name  = "",
                             dxyz = rep (step, 3), beam.nb = 3)
CT <- patient$ct[[1]]
MR <- patient$mr[[1]]
D <- patient$rtdose[[1]]
S <- patient$rtstruct[[1]]

display.plane (bottom = CT, top = D, struct = S, view.coord = -30, 
               interpolate = FALSE, legend.shift = -80)
# Display of CT in reference frame "ref1" and  MR in "ref2"               
display.plane (bottom = CT, top = MR, interpolate = FALSE)

# Display of CT and MR in reference frame "ref2"
display.plane (bottom = CT, top = MR, interpolate = FALSE, display.ref ="ref2",
               T.MAT = patient$T.MAT)
}
\seealso{
\link[espadon]{display.kplane}.
}
