% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_stationinfofile.R
\name{aux_stationinfofile}
\alias{aux_stationinfofile}
\title{Create station info file from cube files.}
\usage{
aux_stationinfofile(
  name,
  input_dir,
  output_dir,
  station_ID,
  station_name,
  station_z,
  station_d,
  sensor_type,
  logger_type,
  sensor_ID,
  logger_ID,
  unit = "dd",
  n,
  quantile = 0.95,
  random = TRUE,
  cpu,
  gipptools,
  write_file = TRUE,
  write_raw = FALSE,
  write_data = FALSE
)
}
\arguments{
\item{name}{\code{Character} value, file name of the output station info 
file, without extention (will be added as *.txt).}

\item{input_dir}{\code{Character} value, path to directory where all cube 
files to be processed as stored. Each set of files from one logger must be 
stored in a separate sub-directory named after the cube ID.}

\item{output_dir}{\code{Character} value, path to directory where output 
data is written to.}

\item{station_ID}{\code{Character} vector, seismic station ID. Each value
must not contain more than 5 characters. Longer entries will be clipped. If  
omitted, a default ID will be created.}

\item{station_name}{\code{Character} vector, seismic station name. If
omitted, the station ID is used as name.}

\item{station_z}{\code{Numeric} vector, elevation of the seismic stations.}

\item{station_d}{\code{Numeric} vector, deployment depth of the seismic sensor.}

\item{sensor_type}{\code{Character} vector, sensor type.}

\item{logger_type}{\code{Character} vector, logger type.}

\item{sensor_ID}{\code{Character} vector, sensor ID.}

\item{logger_ID}{\code{Character} vector, logger ID.}

\item{unit}{\code{Character} value, coordinates unit of the location. One 
out of \code{"dd"} (decimal degrees) and \code{"utm"} (metric in UTM zone). 
Default is \code{"dd"}.}

\item{n}{\code{Numeric} value, number of cube file to process for GPS 
coordinate extraction. If omitted, all files are processed.}

\item{quantile}{\code{Numeric} value, quantile size to which the extracted 
coordinate sample size is restricted. This is mainly used to remove 
coordinate outliers, due to spurious GPS signals. Default is 
\code{0.95}. Set to \code{1} to omit any sample rejection.}

\item{random}{\code{Logical} value, option to draw \code{n} cube files 
randomly instead of ordered by date. Default is \code{TRUE}.}

\item{cpu}{\code{Numeric} value, fraction of CPUs to use for parallel 
processing. If omitted, one CPU is used.}

\item{gipptools}{\code{Character} value, path to gipptools or cubetools 
directory.}

\item{write_file}{\code{Logical} value, option to write station info file 
to disk. Default is \code{TRUE}.}

\item{write_raw}{\code{Logical} value, option to write (keep) raw ASCII 
GPS data. Default is \code{FALSE}.}

\item{write_data}{\code{Logical} value, option to write gps raw data as 
rda-file. File name will be the same as for \code{file}. Default is
\code{FALSE}.}
}
\value{
A set of files written to disk and a data frame with seismic 
station information.
}
\description{
This function reads GPS tags from Omnirecs/Digos Datacube files and creates 
a station info file from additional input data. It depends on the cubetools 
or gipptools software package (see details).
}
\details{
A station info file is an ASCII file that contains all relevant information
about the individual stations of a seismic network. The variables contain a 
station ID (containing not more than 5 characters), station name, latitude, 
longitude, elevation, deployment depth, sensor type, logger type, sensor 
ID and logger ID.\cr The function requires that the software cubetools 
(\code{http://www.omnirecs.de/documents.html}) or gipptools 
(\code{http://www.gfz-potsdam.de/en/section/geophysical-deep-sounding/infrastructure/geophysical-instrument-pool-potsdam-gipp/software/gipptools/}) 
are installed. Note that GPS tag extraction may take several minutes per 
cube file. Hence, depending on the number of files and utilised CPUs the 
processing may take a while.\cr Specifying an input directory 
(\code{input_dir}) is mandatory. This input directory must only contain the 
subdirectories with the cube files to process, each set of cube files must 
be located in a separate subdirectory and these subdiretories must 
have the same name as specified by the logger IDs (\code{logger_ID}). An 
appropriate structure would be something like: \cr 
\enumerate{
  \item input
  \enumerate{
    \item A1A
      \enumerate{
        \item file1.A1A
        \item file2.A1A
      }
    \item A1B
      \enumerate{
        \item file1.A1B
        \item file2.A1B
      }
   }
}
}
\examples{

\dontrun{

## basic example with minimum effort
aux_stationinfofile(name = "stationinfo", 
                    input_dir = "input", 
                    logger_ID = c("864", "876", "AB1"),
                    gipptools = "software/gipptools-2015.225")

## example with more adjustments
aux_stationinfofile(name = "stationinfo",
                    input_dir = "input",
                    logger_ID = c("864", "876", "AB1"),
                    station_name = c("KTZ01", "KTZ02", "KTZ03"), 
                    station_z = c(30, 28, 29), 
                    station_d = rep(0.5, 3), 
                    sensor_type = rep("TC120s", 3), 
                    logger_type = rep("Cube3ext", 3), 
                    unit = "utm", 
                    n = 1, 
                    cpu = 0.9,
                    gipptools = "software/gipptools-2015.225", 
                    write_raw = TRUE, 
                    write_data = TRUE)

}

}
\author{
Michael Dietze
}
\keyword{eseis}
