% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{def_dist_reporting_delay}
\alias{def_dist_reporting_delay}
\title{Define a family of reporting delay distributions}
\usage{
def_dist_reporting_delay(pathogen = "sarscov2")
}
\arguments{
\item{pathogen}{String. Name of the pathogen ('sarscov2', 'influenza')}
}
\value{
List with components
\itemize{
\item \code{dist} distribution type (\emph{e.g.} \code{lnorm} = log-normal, \code{gamma} = Gamma, \code{unif} = uniform)
\item \code{mean} distribution mean (only for \code{dist} = \code{lnorm} or \code{gamma})
\item \code{mean_sd} standard deviation of the mean (only for \code{dist} = \code{lnorm} or \code{gamma})
\item \code{sd} standard deviation (only for \code{dist} = \code{lnorm} or \code{gamma})
\item \code{sd_sd} standard deviation of the standard deviation (only for \code{dist} = \code{lnorm} or \code{gamma})
\item \code{min} minimum value of the random variable modelled by this distribution (only for \code{dist} = \code{unif})
\item \code{max} maximum value of the random variable modelled by this distribution
}
}
\description{
Default values come from analyzing COVID-19 line list data across all of Canada for the time period matching the sample COVID-19 clinical data provided in \link{cl.input}
}
\examples{
d = def_dist_reporting_delay(pathogen = 'sarscov2')
print(d)

}
