% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitWtErgmTerm.R
\name{nodeicovar-ergmTerm}
\alias{nodeicovar-ergmTerm}
\alias{InitWtErgmTerm.nodeicovar}
\alias{nodeisqrtcovar-ergmTerm}
\title{Covariance of in-dyad values incident on each actor}
\usage{
# valued: nodeicovar(center, transform)
}
\arguments{
\item{center}{If \code{center=TRUE} , the \eqn{y_{\cdot,\cdot}} s are
centered by their mean over the whole network before the
calculation. Note that this makes the model non-local, but it may
alleviate multimodailty.}

\item{transform}{If \code{transform="sqrt"} ,
\eqn{y_{\cdot,\cdot}} s are repaced by their square roots before the
calculation. This makes sense for counts in particular. If
\code{center=TRUE} as well, they are centered by the mean of the
square roots.}
}
\description{
This term adds one statistic equal to
\eqn{\sum_{i,j,k} y_{j,i}y_{k,i}/(n-2)} . This can be
viewed as a valued analog of the \code{istar(2)} statistic.
}
\note{
Note that this term replaces \code{nodeisqrtcovar} , which has been
deprecated in favor of \code{nodeicovar(transform="sqrt")} .
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "nodeicovar", "subsection")}
}
\concept{directed}
