% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{edgecov-ergmTerm}
\alias{edgecov-ergmTerm}
\alias{InitErgmTerm.edgecov}
\alias{InitWtErgmTerm.edgecov}
\title{Edge covariate}
\usage{
# binary: edgecov(x, attrname=NULL)

# valued: edgecov(x, attrname=NULL, form="sum")
}
\arguments{
\item{x, attrname}{either a square matrix of covariates, one for each possible
edge in the network, the name of a network attribute of covariates,
or a network; if the latter, optional argument \code{attrname} provides
the name of the quantitative edge attribute to use for covariate values
(in this case, missing edges in \code{x} are assigned a covariate value
of zero).}

\item{form}{character how to aggregate tie values in a valued ERGM}
}
\description{
This term adds one statistic to the model, equal to the sum
of the covariate values for each edge appearing in the network. The
\code{edgecov} term applies to both directed and undirected networks. For
undirected networks the covariates are also assumed to be undirected. The
\code{edgecov} and \code{dyadcov} terms are equivalent for undirected
networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{directed}
\concept{dyad-independent}
\concept{frequently-used}
\concept{undirected}
