% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ergm.R
\name{predict.formula}
\alias{predict.formula}
\alias{predict.ergm}
\title{ERGM-based tie probabilities}
\usage{
\method{predict}{formula}(
  object,
  eta,
  conditional = TRUE,
  type = c("response", "link"),
  nsim = 100,
  output = c("data.frame", "matrix"),
  ...,
  basis = ergm.getnetwork(object),
  theta = NULL
)

\method{predict}{ergm}(object, ...)
}
\arguments{
\item{object}{a formula or a fitted ERGM model object}

\item{eta}{numeric vector of ERGM model \emph{canonical} parameter values}

\item{conditional}{logical whether to compute conditional or unconditional
predicted probabilities}

\item{type}{character element, one of \code{"response"} (default) or \code{"link"} -
whether the returned predictions are on the probability scale or on the
scale of linear predictor. This is similar to \code{type} argument of \code{\link[=predict.glm]{predict.glm()}}.}

\item{nsim}{integer, number of simulated networks used for computing
unconditional probabilities. Defaults to 100.}

\item{output}{character, type of object returned. Defaults to \code{"data.frame"}.
See section Value below.}

\item{...}{other arguments passed to/from other methods. For the \code{predict.formula} method, if
\code{conditional=TRUE} arguments are passed to \code{\link[=ergmMPLE]{ergmMPLE()}}. If \code{conditional=FALSE} arguments
are passed to \code{\link[=simulate_formula]{simulate_formula()}}.}

\item{basis}{a value (usually a \code{\link[network:network]{network}}) to override the LHS of the formula.}

\item{theta}{deprecated name for the parameter vector, renamed to
\code{eta} since the canonical parameters are expected.}
}
\value{
Type of object returned depends on the argument \code{output}. If
\code{output="data.frame"} the function will return a data frame with columns:
\itemize{
\item \code{tail}, \code{head} -- indices of nodes identifying a dyad
\item \code{p} -- predicted conditional tie probability
}

If \code{output="matrix"} the function will return an "adjacency matrix" with the
predicted probabilities. Diagonal values are 0s.
}
\description{
Calculate model-predicted \strong{conditional} and \strong{unconditional} tie
probabilities for dyads in the given network. Conditional probabilities of a
dyad given the state of all the remaining dyads in the graph are computed
exactly. Unconditional probabilities are computed through simulating networks
using the given model. Currently there are two methods implemented:
\itemize{
\item Method for formula objects requires (1) an ERGM model formula with an existing
network object on the left hand side and model terms on the right hand side, and
(2) a vector of corresponding parameter values.
\item Method for \code{ergm} objects, as returned by \code{\link[=ergm]{ergm()}}, takes both the formula
and parameter values from the fitted model object.
}

Both methods can limit calculations to specific set of dyads of interest.
}
\examples{
# A three-node empty directed network
net <- network.initialize(3, directed=TRUE)

# In homogeneous Bernoulli model with odds of a tie of 1/5 all ties are
# equally likely
predict(net ~ edges, log(1/5))

# Let's add a tie so that `net` has 1 tie out of possible 6 (so odds of 1/5)
net[1,2] <- 1

# Fit the model
fit <- ergm(net ~ edges)

# The p's should be identical
predict(fit)
}
