% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5dlfs.R
\name{lfs}
\alias{lfs}
\title{Calculate the Level Freqeuncy Score for an EQ-5D profile}
\usage{
lfs(scores, version, ignore.invalid, ...)
}
\arguments{
\item{scores}{data.frame with names MO, SC, UA, PD and AD representing
Mobility, Self-care, Usual activities, Pain/discomfort and Anxiety/depression.}

\item{version}{string of value "3L", "5L" or "Y" to indicate instrument version.}

\item{ignore.invalid}{whether to ignore invalid scores. TRUE returns NA, FALSE throws an 
error.}

\item{...}{character vector, specifying "dimensions" column names. Defaults 
are "MO", "SC", "UA", "PD" and "AD".}
}
\value{
a data.frame or list of data.frames of counts/percentages. Columns 
contain dimensions names and rows the EQ-5D score.
}
\description{
Calculate the Levels Frequency Score for a single or number of EQ-5D profiles
}
\examples{
lfs(c(MO=1,SC=2,UA=3,PD=2,AD=1), version="3L")
lfs(55555, version="5L")
lfs(c(11111, 12345, 55555), version="5L")


}
