% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dict.R
\name{Cmip6Dict}
\alias{Cmip6Dict}
\alias{cmip6_dict}
\title{CMIP6 Controlled Vocabularies (CVs) and Data Request Dictionary}
\usage{
cmip6_dict()
}
\description{
The \code{Cmip6Dict} object provides functionalities to fetch the latest CMIP6
Controlled Vocabularies (CVs) and Data Request (DReq) information.
}
\details{
The CMIP6 CVs gives a well-defined set of global attributes that are recorded
in each CMIP6 model output, providing information necessary for interpreting
the data. The data of CMIP6 CVs is stored as JSON files in the WCRP-CMIP
\href{https://github.com/WCRP-CMIP/CMIP6_CVs}{GitHub Repo}.

The CMIP6 DReq defines all the quantities from CMIP6 simulations that should
be archived. This includes both quantities of general interest needed from
most of the CMIP6-endorsed model intercomparison projects (MIPs) and
quantities that are more specialized and only of interest to a single
endorsed MIP. The raw data of DReq is stored a Microsoft Excel file
(\code{CMIP6_MIP_tables.xlsx}) in a Subversion repo.
The \code{Cmip6Dict} object uses the parsed DReq data that is stored in the
\href{https://github.com/PCMDI/cmip6-cmor-tables}{GitHub Repo}.

For more information, please see:
\itemize{
\item \href{https://docs.google.com/document/d/1h0r8RZr_f3-8egBMMh7aqLwy3snpD6_MrDz1q8n5XUk/edit}{CMIP6 Global Attributes, DRS, Filenames, Directory Structure, and CV's}
\item \href{https://wcrp-cmip.github.io/WGCM_Infrastructure_Panel/CMIP6/data_request.html}{CMIP6 Data Request}
}
}
\examples{
\dontrun{

# create a new Cmip6Dict object
dict <- cmip6_dict()

# by default, there is no data when the Cmip6Dict was created
dict$is_empty()

# fetch and parse all CVs and Data Request data
dict$build()

# get the version of CVs nand Data Request
dict$version()

# get the last modified time for each CV and Data Request
dict$timestamp()

# get the time when the dict was built
dict$built_time()

# get the data of CVs and DReq
dict$get("activity_id")
dict$get("experiment_id")
dict$get("sub_experiment_id")
dict$get("institution_id")
dict$get("source_id")
dict$get("table_id")
dict$get("frequency")
dict$get("grid_label")
dict$get("realm")
dict$get("source_type")
dict$get("dreq")

# save the dict object for later usage
# default location is the value of global option "epwshiftr.dir"
dict$save()

# the saved dict object can be reloaded
new_dict <- cmip6_dict()
new_dict$load()

# print will show the version summary and the last built time
dict$print()
}
}
\author{
Hongyuan Jia
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Cmip6Dict-version}{\code{Cmip6Dict$version()}}
\item \href{#method-Cmip6Dict-is_empty}{\code{Cmip6Dict$is_empty()}}
\item \href{#method-Cmip6Dict-timestamp}{\code{Cmip6Dict$timestamp()}}
\item \href{#method-Cmip6Dict-built_time}{\code{Cmip6Dict$built_time()}}
\item \href{#method-Cmip6Dict-build}{\code{Cmip6Dict$build()}}
\item \href{#method-Cmip6Dict-get}{\code{Cmip6Dict$get()}}
\item \href{#method-Cmip6Dict-save}{\code{Cmip6Dict$save()}}
\item \href{#method-Cmip6Dict-load}{\code{Cmip6Dict$load()}}
\item \href{#method-Cmip6Dict-print}{\code{Cmip6Dict$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Cmip6Dict-version"></a>}}
\if{latex}{\out{\hypertarget{method-Cmip6Dict-version}{}}}
\subsection{Method \code{version()}}{
Get the version of CVs and Data Request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cmip6Dict$version()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of two element:
\itemize{
\item \code{cvs}: A \link{numeric_version} object giving the version of CVs
\item \code{dreq}: A \link{numeric_version} object giving the version of Data
Request
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Cmip6Dict-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-Cmip6Dict-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
Is it an empty Cmip6Dict?

\verb{$is_empty()} checks if this \code{Cmip6Dict} is empty, i.e. the \verb{$build() } or \verb{$load()} method hasn't been called yet and there is no data of
CVs and Data Request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cmip6Dict$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A single logical value of \code{TRUE} or \code{FALSE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Cmip6Dict-timestamp"></a>}}
\if{latex}{\out{\hypertarget{method-Cmip6Dict-timestamp}{}}}
\subsection{Method \code{timestamp()}}{
Get the last modified time for CVs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cmip6Dict$timestamp()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of 14 \link[=POSIXct]{DateTime}s:
\itemize{
\item \code{"cvs"}: The last modified time for the whole CV collection
\item \code{"drs"}: The last modified time for Data Reference Syntax (DRS)
\item \code{"activity_id"}: The last modified time for Activity ID
\item \code{"experiment_id"}: The last modified time for Experiment ID
\item \code{"frequency"}: The last modified time for Frequency
\item \code{"grid_label"}: The last modified time for Grid Label
\item \code{"institution_id"}: The last modified time for Institution ID
\item \code{"nominal_resolution"}: The last modified time for Nominal Resolution
\item \code{"realm"}: The last modified time for Realm
\item \code{"required_global_attributes"}: The last modified time for Required Global Attributes
\item \code{"source_id"}: The last modified time for Source ID
\item \code{"source_type"}: The last modified time for Source Type
\item \code{"sub_experiment_id"}: The last modified time for Sub-Experiment ID
\item \code{"table_id"}: The last modified time for Table ID
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Cmip6Dict-built_time"></a>}}
\if{latex}{\out{\hypertarget{method-Cmip6Dict-built_time}{}}}
\subsection{Method \code{built_time()}}{
Get the time when the dictionary was built
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cmip6Dict$built_time()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link[=POSIXct]{DateTime}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Cmip6Dict-build"></a>}}
\if{latex}{\out{\hypertarget{method-Cmip6Dict-build}{}}}
\subsection{Method \code{build()}}{
Fetch and parse all data of CVs and Data Request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cmip6Dict$build(token = NULL, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{A string of GitHub token that is used to access GitHub
REST APIs. If \code{NULL}, \code{GITHUB_PAT} or \code{GITHUB_TOKEN}
environment variable will be used if exists. Default: \code{NULL}.}

\item{\code{force}}{Whether to force to rebuild the dict when it has been
already built before. Default: \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The updated \code{Cmip6Dict} itself.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Cmip6Dict-get"></a>}}
\if{latex}{\out{\hypertarget{method-Cmip6Dict-get}{}}}
\subsection{Method \code{get()}}{
Get the data for a specific CV or Data Request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cmip6Dict$get(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{A single string indicating the type of data to list.
Should be one of:
\itemize{
\item \code{"drs"}: Data Reference Syntax (DRS)
\item \code{"activity_id"}: Activity ID
\item \code{"experiment_id"}: Experiment ID
\item \code{"frequency"}: Frequency
\item \code{"grid_label"}: Grid Label
\item \code{"institution_id"}: Institution ID
\item \code{"nominal_resolution"}: Nominal Resolution
\item \code{"realm"}: Realm
\item \code{"required_global_attributes"}: Required Global Attributes
\item \code{"source_id"}: Source ID
\item \code{"source_type"}: Source Type
\item \code{"sub_experiment_id"}: Sub-Experiment ID
\item \code{"table_id"}: Table ID
\item \code{"dreq"}: Data Request
}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
For \code{"drs"}, "activity_id"\verb{, }"frequency"\verb{, }"grid_label"\verb{, }"institution_id"\verb{, }"source_type"\code{and}"sub_experiment_id"`, a
\link{list}.

For \code{"experiment_id"}, \code{"source_id"} and \code{"dreq"}, a \link{data.table}.

For \code{"nominal_resolution"}, \code{"required_global_attributes"} and
\code{"table_id"}, a \link{character} vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Cmip6Dict-save"></a>}}
\if{latex}{\out{\hypertarget{method-Cmip6Dict-save}{}}}
\subsection{Method \code{save()}}{
Save the Cmip6Dict object

\verb{$save()} stores all the core data of current \code{Cmip6Dict} object into
an \link[=saveRDS]{RDS} file named \code{CMIP6DICT} in the specified folder.
This file can be reloaded via \verb{$load()} method to restore the last
state of current \code{Cmip6Dict} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cmip6Dict$save(dir = getOption("epwshiftr.dir", "."))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{A single string giving the directory to save the RDS file.
Default is set to the global option \code{epwshiftr.dir}. The
directory will be created if not exists. If this global option
is not set, the current working directory is used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A single string giving the full path of the RDS file.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Cmip6Dict-load"></a>}}
\if{latex}{\out{\hypertarget{method-Cmip6Dict-load}{}}}
\subsection{Method \code{load()}}{
Load the saved Cmip6Dict object from file

\verb{$load()} loads the RDS file named \code{CMIP6DICT} that is created using
\verb{$save()} method.

Please note that the file should be exactly the same as \code{CMIP6DICT}
without file extension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cmip6Dict$load(dir = getOption("epwshiftr.dir", "."))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{A single string giving the directory to find the RDS file.
Default is set to the global option \code{epwshiftr.dir}. If this
global option is not set, the current working directory is
used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A single string giving the full path of the RDS file.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Cmip6Dict-print"></a>}}
\if{latex}{\out{\hypertarget{method-Cmip6Dict-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of the current \code{Cmip6Dict} object

\verb{$print()} gives the summary of current \code{Cmip6Dict} object including
the version of CVs and Data Request, and the last built time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cmip6Dict$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{Cmip6Dict} object itself, invisibly.
}
}
}
