##' @title Identify cells that have a certain number of taxa
##'
##' @description Given a epmGrid object, return the grid cell indices
##' 	of those cells that have the specified number of taxa. 
##'
##' @param x object of class \code{epmGrid}
##' @param count number of species to consider (can be a vector of integers)
##'
##' @details This function can be useful when further analyzing epmGrid
##' 	objects generated by \code{\link{gridMetrics}}, as it might
##' 	make sense to exclude certain grid cells in further analyses. 
##'
##' 
##' @return numeric vector of grid cell indices. 
##'
##' @author Pascal Title
##' 
##' @examples
##' spCountIndex(tamiasEPM, count = 1)
##' spCountIndex(tamiasEPM, count = 1:3)
##' 
##' @export



spCountIndex <- function(x, count) {

	if (!inherits(x, 'epmGrid')) {
		stop('Object must be of class epmGrid')
	}
	
	cellCounts <- lengths(x[['speciesList']])
	cellCounts[sapply(x[['speciesList']], anyNA)] <- 0
	
	ind <- which(cellCounts %in% count)
	
	indCells <- which(x[['cellCommInd']] %in% ind)
	return(indCells)
}