% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\docType{class}
\name{ParametricJob}
\alias{ParametricJob}
\alias{param_job}
\title{Create and Run Parametric Analysis, and Collect Results}
\usage{
param_job(idf, epw)
}
\arguments{
\item{idf}{A path to EnergyPlus IDF or IMF file or an \code{Idf} object.}

\item{epw}{A path to EnergyPlus EPW file or an \code{Epw} object. \code{epw} can also
be \code{NULL} which will force design-day-only simulation when
\code{\link[=ParametricJob]{$run()}} method is called. Note this needs at least
one \code{Sizing:DesignDay} object exists in the \link{Idf}.}
}
\value{
A \code{ParametricJob} object.
}
\description{
\code{ParametricJob} class provides a prototype of conducting parametric analysis
of EnergyPlus simulations.

\code{param_job()} takes an IDF and EPW as input and returns a \code{ParametricJob}.
For details on \code{ParametricJob}, please see \link{ParametricJob} class.
}
\details{
Basically, it is a collection of multiple \code{EplusJob} objects. However, the
model is first parsed and the \link{Idf} object is stored internally, instead of
storing only the path of Idf like in \link{EplusJob} class. Also, an object in
\code{Output:SQLite} with \verb{Option Type} value of \code{SimpleAndTabular} will be
automatically created if it does not exists, like \link{Idf} class does.
}
\examples{

## ------------------------------------------------
## Method `ParametricJob$new`
## ------------------------------------------------

\dontrun{
if (is_avail_eplus("8.8")) {
     path_idf <- path_eplus_example("8.8", "5Zone_Transformer.idf")
     path_epw <- path_eplus_weather("8.8", "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw")

    # create from an IDF and an EPW
    param <- param_job(path_idf, path_epw)
    param <- ParametricJob$new(path_idf, path_epw)

    # create from an Idf and an Epw object
    param_job(read_idf(path_idf), read_epw(path_epw))
}
}


## ------------------------------------------------
## Method `ParametricJob$version`
## ------------------------------------------------

\dontrun{
param$version()
}


## ------------------------------------------------
## Method `ParametricJob$seed`
## ------------------------------------------------

\dontrun{
param$seed()
}


## ------------------------------------------------
## Method `ParametricJob$weather`
## ------------------------------------------------

\dontrun{
param$weather()
}


## ------------------------------------------------
## Method `ParametricJob$param`
## ------------------------------------------------

\dontrun{

param$param(
    Material := .(
        Thickness = seq(0.1, 1, length.out = 3),
        Conductivity = seq(0.1, 0.6, length.out = 3)
    ),
   "Supply Fan 1" = .(fan_total_efficiency = c(0.1, 0.5, 0.8))
)

# specify parameter values
param$param(
    Material := .(
        Thickness = seq(0.1, 1, length.out = 3),
        Conductivity = seq(0.1, 0.6, length.out = 3)
     ),
    "Supply Fan 1" = list(fan_total_efficiency = c(0.1, 0.5, 0.8)),
    .names = c("thickness", "conduct", "fan_eff")
)

# each parameter should have the same length of values
try(
param$param(
    Material := list(Thickness = c(0.1, 0.2)),
    "Supply Fan 1" = list(fan_total_efficiency = c(0.1, 0.5, 0.8))
)
)

# use all combinations of parameters
param$param(
    Material := list(
        Thickness = seq(0.1, 1, length.out = 3),
        Conductivity = seq(0.1, 0.6, length.out = 3)
    ),
    "Supply Fan 1" = list(fan_total_efficiency = c(0.1, 0.5, 0.8)),
    .cross = TRUE
)
}


## ------------------------------------------------
## Method `ParametricJob$apply_measure`
## ------------------------------------------------

\dontrun{
# create a measure to change the orientation of the building
rotate_building <- function(idf, degree = 0L) {
    if (!idf$is_valid_class("Building")) {
       stop("Input model does not have a Building object")
    }

    if (degree > 360 || degree < -360 ) {
        stop("Input degree should in range [-360, 360]")
    }

    cur <- idf$Building$North_Axis

    new <- cur + degree

    if (new > 360) {
        new <- new \%\% 360
        warning("Calculated new north axis is greater than 360. ",
            "Final north axis will be ", new
        )
    } else if (new < -360) {
        new <- new \%\% -360
        warning("Calculated new north axis is smaller than -360. ",
            "Final north axis will be ", new
        )
    }

    idf$Building$North_Axis <- new

    idf
}

# apply measure
# this will create 12 models
param$apply_measure(rotate_building, degree = seq(30, 360, 30))

# apply measure with new names specified
param$apply_measure(rotate_building, degree = seq(30, 360, 30),
    .names = paste0("rotate_", seq(30, 360, 30))
)
}


## ------------------------------------------------
## Method `ParametricJob$models`
## ------------------------------------------------

\dontrun{
param$models()
}


## ------------------------------------------------
## Method `ParametricJob$cases`
## ------------------------------------------------

\dontrun{
param$cases()
}


## ------------------------------------------------
## Method `ParametricJob$save`
## ------------------------------------------------

\dontrun{
# save all parametric models with each model in a separate folder
param$save(tempdir())

# save all parametric models with all models in the same folder
param$save(tempdir(), separate = FALSE)
}


## ------------------------------------------------
## Method `ParametricJob$run`
## ------------------------------------------------

\dontrun{
# run parametric simulations
param$run(wait = TRUE, echo = FALSE)

# run in background
param$run(wait = FALSE)
# get detailed job status by printing
print(param)
}


## ------------------------------------------------
## Method `ParametricJob$print`
## ------------------------------------------------

\dontrun{
param$print()

Sys.sleep(10)
param$print()
}

}
\seealso{
\code{\link[=eplus_job]{eplus_job()}} for creating an EnergyPlus single simulation job.
}
\author{
Hongyuan Jia
}
\section{Super class}{
\code{\link[eplusr:EplusGroupJob]{eplusr::EplusGroupJob}} -> \code{ParametricJob}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ParametricJob-new}{\code{ParametricJob$new()}}
\item \href{#method-ParametricJob-version}{\code{ParametricJob$version()}}
\item \href{#method-ParametricJob-seed}{\code{ParametricJob$seed()}}
\item \href{#method-ParametricJob-weather}{\code{ParametricJob$weather()}}
\item \href{#method-ParametricJob-param}{\code{ParametricJob$param()}}
\item \href{#method-ParametricJob-apply_measure}{\code{ParametricJob$apply_measure()}}
\item \href{#method-ParametricJob-models}{\code{ParametricJob$models()}}
\item \href{#method-ParametricJob-cases}{\code{ParametricJob$cases()}}
\item \href{#method-ParametricJob-save}{\code{ParametricJob$save()}}
\item \href{#method-ParametricJob-run}{\code{ParametricJob$run()}}
\item \href{#method-ParametricJob-print}{\code{ParametricJob$print()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="errors"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-errors'><code>eplusr::EplusGroupJob$errors()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="kill"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-kill'><code>eplusr::EplusGroupJob$kill()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="list_files"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-list_files'><code>eplusr::EplusGroupJob$list_files()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="list_table"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-list_table'><code>eplusr::EplusGroupJob$list_table()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="locate_output"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-locate_output'><code>eplusr::EplusGroupJob$locate_output()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="output_dir"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-output_dir'><code>eplusr::EplusGroupJob$output_dir()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="read_mdd"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-read_mdd'><code>eplusr::EplusGroupJob$read_mdd()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="read_rdd"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-read_rdd'><code>eplusr::EplusGroupJob$read_rdd()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="read_table"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-read_table'><code>eplusr::EplusGroupJob$read_table()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="report_data"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-report_data'><code>eplusr::EplusGroupJob$report_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="report_data_dict"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-report_data_dict'><code>eplusr::EplusGroupJob$report_data_dict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="status"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-status'><code>eplusr::EplusGroupJob$status()</code></a></span></li>
<li><span class="pkg-link" data-pkg="eplusr" data-topic="EplusGroupJob" data-id="tabular_data"><a href='../../eplusr/html/EplusGroupJob.html#method-EplusGroupJob-tabular_data'><code>eplusr::EplusGroupJob$tabular_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParametricJob-new"></a>}}
\if{latex}{\out{\hypertarget{method-ParametricJob-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{ParametricJob} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$new(idf, epw)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{idf}}{Path to EnergyPlus IDF file or an \code{Idf} object.}

\item{\code{epw}}{Path to EnergyPlus EPW file or an \code{Epw} object. \code{epw} can
also be \code{NULL} which will force design-day-only simulation
when \verb{$run()} method is called. Note this needs at least one
\code{Sizing:DesignDay} object exists in the \link{Idf}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{ParametricJob} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
if (is_avail_eplus("8.8")) {
     path_idf <- path_eplus_example("8.8", "5Zone_Transformer.idf")
     path_epw <- path_eplus_weather("8.8", "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw")

    # create from an IDF and an EPW
    param <- param_job(path_idf, path_epw)
    param <- ParametricJob$new(path_idf, path_epw)

    # create from an Idf and an Epw object
    param_job(read_idf(path_idf), read_epw(path_epw))
}
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParametricJob-version"></a>}}
\if{latex}{\out{\hypertarget{method-ParametricJob-version}{}}}
\subsection{Method \code{version()}}{
Get the version of seed IDF
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$version()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$version()} returns the version of input seed \link{Idf} object.
}

\subsection{Returns}{
A \code{\link[base:numeric_version]{base::numeric_version()}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
param$version()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParametricJob-seed"></a>}}
\if{latex}{\out{\hypertarget{method-ParametricJob-seed}{}}}
\subsection{Method \code{seed()}}{
Get the seed \link{Idf} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$seed()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$seed()} returns the parsed input seed \link{Idf} object.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
param$seed()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParametricJob-weather"></a>}}
\if{latex}{\out{\hypertarget{method-ParametricJob-weather}{}}}
\subsection{Method \code{weather()}}{
Get the \link{Epw} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$weather()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$weather()} returns the input \link{Epw} object. If no \link{Epw} is provided
when creating the \code{ParametricJob} object, \code{NULL} is returned.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
param$weather()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParametricJob-param"></a>}}
\if{latex}{\out{\hypertarget{method-ParametricJob-param}{}}}
\subsection{Method \code{param()}}{
Set parameters for parametric simulations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$param(..., .names = NULL, .cross = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Lists of paramter definitions. Please see above on the
syntax.}

\item{\code{.names}}{A character vector of the parameter names. If \code{NULL},
the parameter will be named in format \code{param_X}, where
\code{X} is the index of parameter. Default: \code{NULL}.}

\item{\code{.cross}}{If \code{TRUE}, all combinations of parameter values will be
used to create models. If \code{FALSE}, each parameter should have
the same length of values. Default: \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$param()} takes parameter definitions in list format, which is
similar to \link[=Idf]{Idf$set()} except that each field is not assigned
with a single value, but a vector of any length, indicating the
levels of each parameter.

Similar like the way of modifying object field values in
\link[=Idf]{Idf$set()}, there are 3 different ways of defining a parameter
in epluspar:
\itemize{
\item \code{object = list(field = c(value1, value2, ...))}: Where \code{object} is
a valid object ID or name. Note object ID should be denoted with
two periods \code{..}, e.g. \code{..10} indicates the object with ID \code{10}, It
will set that specific field in that object as one parameter.
\item \code{.(object, object) := list(field = c(value1, value2, ...))}:
Simimar like above, but note the use of \code{.()} in the left hand
side.  You can put multiple object ID or names in \code{.()}. It will
set the field of all specified objects as one parameter.
\item \code{class := list(field = c(value1, value2, ...))}: Note the use of
\verb{:=} instead of \code{=}. The main difference is that, unlike \code{=}, the
left hand side of \verb{:=} should be a valid class name in current
\link{Idf}. It will set that field of all objects in specified
class as one parameter.
}

For example, the code block below defines 3 parameters:
\itemize{
\item Field \verb{Fan Total Efficiency} in object named \verb{Supply Fan 1} in class
\code{Fan:VariableVolume} class, with 10 levels being 0.1 to 1.0 with a
0.1 step.
\item Field \code{Thickness} in all objects in class \code{Material}, with 10
levels being 0.01 to 0.1 m with a 0.1 m step.
\item Field \code{Conductivity} in all objects in class \code{Material}, with 10
levels being 0.1 to 1.0 W/m-K with a 0.1 W/m-K step.
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{param$param(
    `Supply Fan 1` = list(Fan_Total_Efficiency = seq(0.1, 1.0, 0.1)),
    Material := list(
        Thickness = seq(0.01, 0.1, 0.1),
        Conductivity = seq(0.1, 1.0, 0.1)
    )
)
}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The modified \code{ParametricJob} object invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{

param$param(
    Material := .(
        Thickness = seq(0.1, 1, length.out = 3),
        Conductivity = seq(0.1, 0.6, length.out = 3)
    ),
   "Supply Fan 1" = .(fan_total_efficiency = c(0.1, 0.5, 0.8))
)

# specify parameter values
param$param(
    Material := .(
        Thickness = seq(0.1, 1, length.out = 3),
        Conductivity = seq(0.1, 0.6, length.out = 3)
     ),
    "Supply Fan 1" = list(fan_total_efficiency = c(0.1, 0.5, 0.8)),
    .names = c("thickness", "conduct", "fan_eff")
)

# each parameter should have the same length of values
try(
param$param(
    Material := list(Thickness = c(0.1, 0.2)),
    "Supply Fan 1" = list(fan_total_efficiency = c(0.1, 0.5, 0.8))
)
)

# use all combinations of parameters
param$param(
    Material := list(
        Thickness = seq(0.1, 1, length.out = 3),
        Conductivity = seq(0.1, 0.6, length.out = 3)
    ),
    "Supply Fan 1" = list(fan_total_efficiency = c(0.1, 0.5, 0.8)),
    .cross = TRUE
)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParametricJob-apply_measure"></a>}}
\if{latex}{\out{\hypertarget{method-ParametricJob-apply_measure}{}}}
\subsection{Method \code{apply_measure()}}{
Create parametric models
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$apply_measure(measure, ..., .names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measure}}{A function that takes an \code{Idf} and other arguments as
input and returns an \link{Idf} object as output.}

\item{\code{...}}{Arguments \strong{except first \code{Idf} argument} that are passed
to that \code{measure}.}

\item{\code{.names}}{A character vector of the names of parametric \code{Idf}s.
If \code{NULL}, the new \code{Idf}s will be named in format
\code{measure_name + number}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$apply_measure()} allows to apply a measure to an \link{Idf} and creates
parametric models for analysis. Basically, a measure is just a
function that takes an \link{Idf} object and other arguements as input, and
returns a modified \link{Idf} object as output. Use \code{...} to supply
different arguments, \strong{except for the first \code{Idf} argument}, to that
measure. Under the hook, \code{\link[base:mapply]{base::mapply()}} is used to create multiple
\link{Idf}s according to the input values.
}

\subsection{Returns}{
The modified \code{ParametricJob} object itself, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# create a measure to change the orientation of the building
rotate_building <- function(idf, degree = 0L) {
    if (!idf$is_valid_class("Building")) {
       stop("Input model does not have a Building object")
    }

    if (degree > 360 || degree < -360 ) {
        stop("Input degree should in range [-360, 360]")
    }

    cur <- idf$Building$North_Axis

    new <- cur + degree

    if (new > 360) {
        new <- new \%\% 360
        warning("Calculated new north axis is greater than 360. ",
            "Final north axis will be ", new
        )
    } else if (new < -360) {
        new <- new \%\% -360
        warning("Calculated new north axis is smaller than -360. ",
            "Final north axis will be ", new
        )
    }

    idf$Building$North_Axis <- new

    idf
}

# apply measure
# this will create 12 models
param$apply_measure(rotate_building, degree = seq(30, 360, 30))

# apply measure with new names specified
param$apply_measure(rotate_building, degree = seq(30, 360, 30),
    .names = paste0("rotate_", seq(30, 360, 30))
)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParametricJob-models"></a>}}
\if{latex}{\out{\hypertarget{method-ParametricJob-models}{}}}
\subsection{Method \code{models()}}{
Get created parametric \link{Idf} objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$models(names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{names}}{A character vector of new names for parametric models.
If a single string, it will be used as a prefix and all models
will be named in pattern \code{names_X}, where \code{X} is the model
index. If \code{NULL}, existing parametric models are directly
returned. Default: \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$models()} returns a list of parametric models generated using input
\link{Idf} object and
\href{../../eplusr/html/ParametricJob.html#method-apply_measure}{\code{$apply_measure()}}
method. Model names are assigned in the same way as the \code{.names}
arugment in
\href{../../eplusr/html/ParametricJob.html#method-apply_measure}{\code{$apply_measure()}}.
If no measure has been applied, \code{NULL} is returned. Note that it is
not recommended to conduct any extra modification on those models
directly, after they were created using
\href{../../eplusr/html/ParametricJob.html#method-apply_measure}{\code{$apply_measure()}},
as this may lead to an un-reproducible process. A warning message
will be issued if any of those models has been modified when running
simulations.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
param$models()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParametricJob-cases"></a>}}
\if{latex}{\out{\hypertarget{method-ParametricJob-cases}{}}}
\subsection{Method \code{cases()}}{
Get a summary of parametric models and parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$cases()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$cases()} returns a \link[data.table:data.table]{data.table} giving a
summary of parametric models and parameter values.

The returned \code{data.table} has the following columns:
\itemize{
\item \code{index}: Integer type. The indices of parameter models
\item \code{case}: Character type. The names of parameter models
\item Parameters: Type depends on the parameter values. Each parameter
stands in a separate column. For parametric models created using
\code{ParametricJob$param()}, the column names will be the same as what
you specified in \code{.names}. For the case of
\code{ParametricJob$apply_measure()}, this will be the argument names of
the measure functions.
}
}

\subsection{Returns}{
If no parametric models have been created, \code{NULL} is
returned. Otherwise, a \link[data.table:data.table]{data.table}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
param$cases()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParametricJob-save"></a>}}
\if{latex}{\out{\hypertarget{method-ParametricJob-save}{}}}
\subsection{Method \code{save()}}{
Save parametric models
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$save(dir = NULL, separate = TRUE, copy_external = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{The parent output directory for models to be saved. If
\code{NULL}, the directory of the seed model will be used. Default:
\code{NULL}.}

\item{\code{separate}}{If \code{TRUE}, all models are saved in a separate folder
with each model's name under specified directory. If \code{FALSE},
all models are saved in the specified directory. Default:
\code{TRUE}.}

\item{\code{copy_external}}{Only applicable when \code{separate} is \code{TRUE}. If
\code{TRUE}, the external files that every \code{Idf} object depends on
will also be copied into the saving directory. The values of
file paths in the Idf will be changed automatically.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$save()} saves all parametric models in specified folder. An error
will be issued if no measure has been applied.
}

\subsection{Returns}{
A \code{\link[data.table:data.table]{data.table::data.table()}} with two columns:
\itemize{
\item model: The path of saved parametric model files.
\item weather: The path of saved weather files.
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# save all parametric models with each model in a separate folder
param$save(tempdir())

# save all parametric models with all models in the same folder
param$save(tempdir(), separate = FALSE)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParametricJob-run"></a>}}
\if{latex}{\out{\hypertarget{method-ParametricJob-run}{}}}
\subsection{Method \code{run()}}{
Run parametric simulations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$run(
  dir = NULL,
  wait = TRUE,
  force = FALSE,
  copy_external = FALSE,
  echo = wait,
  separate = TRUE,
  readvars = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{The parent output directory for specified simulations.
Outputs of each simulation are placed in a separate folder
under the parent directory. If \code{NULL}, the directory of the
seed model will be used. Default: \code{NULL}.}

\item{\code{wait}}{If \code{TRUE}, R will hang on and wait all EnergyPlus
simulations finish. If \code{FALSE}, all EnergyPlus simulations are
run in the background.  Default: \code{TRUE}.}

\item{\code{force}}{Only applicable when the last simulation runs with
\code{wait} equals to \code{FALSE} and is still running. If \code{TRUE},
current running job is forced to stop and a new one will
start. Default: \code{FALSE}.}

\item{\code{copy_external}}{If \code{TRUE}, the external files that current \code{Idf}
object depends on will also be copied into the simulation
output directory. The values of file paths in the Idf will be
changed automatically. Currently, only \code{Schedule:File} class
is supported.  This ensures that the output directory will
have all files needed for the model to run. Default is
\code{FALSE}.}

\item{\code{echo}}{Only applicable when \code{wait} is \code{TRUE}. Whether to
simulation status. Default: same as \code{wait}.}

\item{\code{separate}}{If \code{TRUE}, all models are saved in a separate folder
with each model's name under \code{dir} when simulation. If \code{FALSE},
all models are saved in \code{dir} when simulation. Default:
\code{TRUE}.}

\item{\code{readvars}}{If \code{TRUE}, the \code{ReadVarESO} post-processor will run
to generate CSV files from the ESO output. Since those CSV
files are never used when extracting simulation data in eplusr,
setting it to \code{FALSE} can speed up the simulation if there are
hundreds of output variables or meters. Default: \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\verb{$run()} runs all parametric simulations in parallel. The number of
parallel EnergyPlus process can be controlled by
\code{eplusr_option("num_parallel")}. If \code{wait} is FALSE, then the job
will be run in the background. You can get updated job status by just
printing the \code{ParametricJob} object.
}

\subsection{Returns}{
The \code{ParametricJob} object itself, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# run parametric simulations
param$run(wait = TRUE, echo = FALSE)

# run in background
param$run(wait = FALSE)
# get detailed job status by printing
print(param)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParametricJob-print"></a>}}
\if{latex}{\out{\hypertarget{method-ParametricJob-print}{}}}
\subsection{Method \code{print()}}{
Print \code{ParametricJob} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParametricJob$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\verb{$print()} shows the core information of this \code{ParametricJob},
including the path of IDFs and EPWs and also the simulation job
status.

\verb{$print()} is quite useful to get the simulation status, especially
when \code{wait} is \code{FALSE} in \verb{$run()}. The job status will be updated
and printed whenever \verb{$print()} is called.
}

\subsection{Returns}{
The \code{ParametricJob} object itself, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
param$print()

Sys.sleep(10)
param$print()
}

}
\if{html}{\out{</div>}}

}

}
}
