% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eplusr.R
\docType{package}
\name{eplusr-package}
\alias{eplusr}
\alias{eplusr-package}
\title{eplusr: A Toolkit for Using EnergyPlus in R}
\description{
A rich toolkit of using the whole building
    simulation program 'EnergyPlus'(<https://energyplus.net>), which
    enables programmatic navigation, modification of 'EnergyPlus' models
    and makes it less painful to do parametric simulations and analysis.
}
\details{
eplusr provides a rich toolkit of using EnergyPlus directly in
R, which enables programmatic navigation, modification of EnergyPlus models
and makes it less painful to do parametric simulations and analysis.
}
\section{Features}{

\itemize{
\item Download and install EnergyPlus in R
\item Read, parse and modify EnergyPlus:
\itemize{
\item Input Data File (IDF)
\item Weather File (EPW)
\item Report Data Dictionary (RDD) & Meter Data Dictionary (MDD)
\item Error File (ERR)
}
\item Modify multiple versions of IDFs and run corresponding EnergyPlus
both in the background and in the front
\item Rich-featured interfaces to query and modify IDFs
\item Automatically handle referenced fields and validate input during
modification
\item Take fully advantage of most common used data structure for data
science in R – data.frame
\itemize{
\item Extract model, weather data into data.frames
\item Modify multiple objects via data.frames input
\item Query output via SQL in Tidy format which is much better for
data analysis and visualization
}
\item Provide a simple yet extensible prototype of conducting parametric
simulations and collect all results in one go
\item A pure R-based version updater \code{\link[=transition]{transition()}} which is much faster than
VersionUpdater distributed with EnergyPlus
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://hongyuanjia.github.io/eplusr/}
  \item \url{https://github.com/hongyuanjia/eplusr}
  \item Report bugs at \url{https://github.com/hongyuanjia/eplusr/issues}
}

}
\author{
Hongyuan Jia
}
