% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idf.R
\name{format.Idf}
\alias{format.Idf}
\title{Format an Idf Object}
\usage{
\method{format}{Idf}(x, comment = TRUE, header = TRUE,
  format = eplusr_option("save_format"), leading = 4L, sep_at = 29L,
  ...)
}
\arguments{
\item{x}{An \link{Idf} object.}

\item{comment}{If \code{FALSE}, all comments will not be included. Default: \code{TRUE}.}

\item{header}{If \code{FALSE}, the header will not be included. Default: \code{TRUE}.}

\item{format}{Specific format used when formatting. For details, please see
\code{$save()}. Default: \code{eplusr_option("save_format")}}

\item{leading}{Leading spaces added to each field. Default: \code{4L}.}

\item{sep_at}{The character width to separate value string and field string.
Default: \code{29L} which is the same as IDF Editor.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A single length string.
}
\description{
Format an \link{Idf} object.
}
\examples{
\dontrun{
idf_path <- system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr")
cat(format(read_idf(idf_path, use_idd(8.8, "auto")), leading = 0))
}
}
\author{
Hongyuan Jia
}
