% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HistoricalMarketCapitalization.R
\name{get_historical_market_capitalization_data}
\alias{get_historical_market_capitalization_data}
\title{Get stock market tick data}
\usage{
get_historical_market_capitalization_data(
  api_token,
  ticker,
  from_date = NULL,
  to_date = NULL
)
}
\arguments{
\item{api_token}{The API token for authentication.}

\item{ticker}{is the ticker code and it consists of two parts: SYMBOL_NAME.EXCHANGE_ID}

\item{from_date}{Format: YYYY-MM-DD.}

\item{to_date}{Format: YYYY-MM-DD.}
}
\value{
A list containing the stock market tick data.
}
\description{
This function retrieves stock market tick data from the API.
}
\examples{
api_token <- "demo"
from_date <- "2017-09-10"
to_date <- "2017-09-12"
ticker <- "AAPL"
result <- get_historical_market_capitalization_data(api_token, ticker, from_date, to_date)

}
