\name{qqenvl}
\Rdversion{1.1}
\alias{qqenvl}
\title{
 Confidence bands for the normality plot.
}
\description{
 Add total coverage confidence bands with a fixed level to a probability plot generated by \code{qqnorm}.
}
\usage{
qqenvl(x, datax = FALSE, conf = 95, k = 10000)
}
\arguments{
  \item{x}{ the only sample for qqnorm }
  \item{datax}{logical value. If TRUE the data values will be on the x-axis, if FALSE on the y-axis}
  \item{conf}{confidence level for the bands}
  \item{k}{ number of observations used if a Monte Carlo simulation is need to approximate the p-value}
}
\details{
The function will use an approximating of the p-value for a confidence level of 95\%. For a different level a Monte Carlo approximation is used to calculate the p-value.
}
\references{W. Rolke, The envelope test, Unpublished manuscript, http://charma.uprm.edu/~rolke/publications.htm}
\author{ Felipe Acosta }
\note{
The calculation of the p-values can may take long if \code{k} is large. The minimum recommended value for \code{k} is 5000
}
\seealso{ 
 \code{\link{envl.pval}} for a function to calculate different p-values, \code{\link{qqenvl}} to add confidence bands to a normality plot generated by \code{qqnorm}.
}
\examples{
#Using default options
x=rt(25,5)
qqnorm(x)
qqenvl(x)

#90\% Confidence
x=rnorm(20,-5,30)
qqnorm(x)
qqenvl(x,conf=90,k=5000)
}

\keyword{ htest }
