% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mselect.R
\name{mselect}
\alias{mselect}
\title{envalysis reimplementation of mselect}
\usage{
mselect(object, fctList = NULL, nested = FALSE, 
sorted = c("IC", "Res var", "Lack of fit", "no"), linreg = FALSE, icfct = AIC)
}
\arguments{
\item{object}{an object of class \code{drc}.}

\item{fctList}{a list of dose-response functions to be compared.}

\item{nested}{logical; \code{TRUE} results in F tests between adjacent models
(in \code{fctList}; only sensible for nested models.}

\item{sorted}{character string determining according to which criterion the
model fits are ranked.}

\item{linreg}{logical indicating whether or not additionally polynomial
regression models (linear, quadratic, and cubic models) should be fitted
(they could be useful for a kind of informal lack-of-test consideration for
the models specified,  capturing unexpected departures).}

\item{icfct}{function for supplying the information criterion to be used.
\code{\link{AIC}} and \code{\link{BIC}} are two options.}
}
\value{
A matrix with one row for each model and one column for each criterion.
}
\description{
This function should behave just like \code{\link[drc]{mselect}()}, with the
main difference that model objects are passed through the function instead of
requiring the data to be present in \code{.GlobalEnv}. If you have trouble
with this function, you can use \code{\link[drc]{mselect}()} instead.
}
\details{
For Akaike's information criterion and the residual standard error: the
smaller the better and for lack-of-fit test (against a one-way ANOVA model): 
the larger (the p-value) the better. Note that the residual standard error is
only available for continuous dose-response data.

Log likelihood values cannot be used for comparison unless the models are
nested.
}
\examples{
library(drc)

ryegrass.m1 <- drm(rootl ~ conc, data = ryegrass, fct = LL.4())
mselect(ryegrass.m1, list(LL.3(), LL.5(), W1.3(), W1.4(), W2.4(), baro5()))

}
\author{
Christian Ritz, Zacharias Steinmetz
}
