% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_selected.R
\name{predict_selected}
\alias{predict_selected}
\title{Predictions for the models selected after calibration}
\usage{
predict_selected(fitted, newdata, extrapolation_type = "E",
                 restricted_vars = NULL, type = "response", consensus = TRUE)
}
\arguments{
\item{fitted}{an enmpa-class\verb{fitted models} object obtained using the
functions \code{\link{fit_selected}}.}

\item{newdata}{a \code{SpatRaster}, data.frame, or matrix with the new data on
which to predict.}

\item{extrapolation_type}{(character) to indicate extrapolation type of model.
Models can be transferred with three options: free extrapolation ('E'),
extrapolation with clamping ('EC'), and no extrapolation ('NE').
Default = 'E'.}

\item{restricted_vars}{(character) a vector containing the names of the
variables that will undergo clamping or no extrapolation. For clamping,
these variables are set to minimum and maximum values established for the
max and min values within calibration values. For no extrapolation, the
variables outside calibration limits became NA. If no specific names are
provided, the value is set to NULL by default, indicating that clamping (EC)
or no extrapolation (NE) will be applied to all variables. Ignore if
extrapolation_type = 'E'.}

\item{type}{(character) the type of prediction required. For a default
binomial model the default predictions are of log-odds (probabilities on
logit scale). The default, "response", returns predicted probabilities.}

\item{consensus}{(logical) valid if \code{newdata} is a \code{SpatRaster}, whether to
produce consensus results obtained by combining the predictions from the
collection of selected models. By default consensuses are calculated using
the mean, median, variance, and weighted average using the AIC weights.
Default = TRUE.}
}
\value{
A list with predictions of selected models on the \code{newdata} and fitted
selected model(s). Consensus predictions are added if multiple selected
models exits and if \code{newdata} is a \code{SpatRaster} object.
}
\description{
Wrapper function that facilitates the prediction of those models
selected as the most robust. In addition, it allows the calculation of
consensus models, when more than one model are selected.
}
\examples{
# Load a fitted selected model
data(sel_fit, package = "enmpa")

# Load raster layers to be projected
env_vars <- terra::rast(system.file("extdata", "vars.tif", package = "enmpa"))

# Predictions (only one selected mode, no consensus required)
preds <- predict_selected(sel_fit, newdata = env_vars, consensus = FALSE)

# Plot prediction
terra::plot(preds$predictions)
}
