% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enigma_metadata.r
\name{enigma_metadata}
\alias{enigma_metadata}
\title{Search for metadata on a dataset from Enigma.}
\usage{
enigma_metadata(dataset = NULL, key = NULL, ...)
}
\arguments{
\item{dataset}{Dataset name. Required.}

\item{key}{(character) Required. An Enigma API key. Supply in the function 
call, or store in your \code{.Renviron} file like 
\code{ENIGMA_KEY=your key)}, or in your \code{.Rprofile} file as 
\code{options(enigmaKey = "<your key>")}, Obtain an API key by creating 
an account with Enigma at \url{http://enigma.io}, then obtain an API key 
from your account page.}

\item{...}{Named curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
A list of length 3:
\itemize{
 \item success - a boolean if query was successful or not
 \item datapath - the dataset path (this is not a file path on your machine)
 \item info - a list of length 6 with:
   \itemize{ 
    \item paths - paths under the dataset
    \item immediate_notes - children nodes
    \item children_tables - children tables
   }
}
}
\description{
Search for metadata on a dataset from Enigma.
}
\details{
Notice when you run the examples that the format of output is 
different for the "parent nodes" vs. the "table nodes". Where the parent 
nodes have ouput$meta slots for paths, immediate nodes and children tables, 
while the table nodes have ouput$meta slots for info, table, ancestor 
datapaths, database boundary datapath, database boundary label, database
boundary tables, and paths, and an additional slot for description of table 
column attributes.
}
\examples{
\dontrun{
## After obtaining an API key from Enigma's website, pass in your key to the 
## function call or set in your options (see above instructions for the 
## key parameter) If you pass in your key to the function call use the key 
## parameter

## UCLA Ethnic power relations dataset
enigma_metadata(dataset = 'edu.ucla.epr')

# Table node response attributes
## US white house visitor list table
enigma_metadata(dataset = 'us.gov.whitehouse.visitor-list')
}
}
\references{
\url{https://app.enigma.io/api#metadata}
}
