% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.DBconfig.EMUwebAppConfig.R
\name{SetGetlevelCanvasesOrder}
\alias{SetGetlevelCanvasesOrder}
\alias{set_levelCanvasesOrder}
\alias{get_levelCanvasesOrder}
\title{Set / Get level canvases order of emuDB}
\usage{
set_levelCanvasesOrder(emuDBhandle, perspectiveName, order)

get_levelCanvasesOrder(emuDBhandle, perspectiveName)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{perspectiveName}{name of perspective}

\item{order}{character vector containing names of levelDefinitions}
}
\description{
Set / Get which levels of an emuDB to display as level canvases (in a 
given perspective of the EMU-webApp),
and in what order. Level canvases refer to levels of 
the type "SEGMENT" or "EVENT" that are displayed by the EMU-webApp. Levels 
of type "ITEM" can always be displayed using the hierarchy view of the
web application but can not be displayed as level canvases.
For more information on the structural elements of an emuDB 
see \code{vignette{emuDB}}.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# get level canvases order of ae emuDB
order = get_levelCanvasesOrder(emuDBhandle = ae,
                               perspectiveName = "default")

# reverse the level canvases order of ae emuDB
set_levelCanvasesOrder(emuDBhandle = ae
                       perspectiveName = "default",
                       order = rev(order))
                       
# get level canvases order of ae emuDB                       
get_levelCanvasesOrder(emuDBhandle = ae,
                       perspectiveName = "default")
}

}
\keyword{DBconfig}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}
