% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind.trackdata.R
\name{cbind.trackdata}
\alias{cbind}
\alias{cbind.trackdata}
\title{A method of the generic function cbind for objects of class \'trackdata\'}
\usage{
cbind.trackdata(...)
}
\arguments{
\item{\dots}{track data objects}
}
\value{
A track data object with the same \$index and \$ftime values of the
source track data objects and with \$data that includes all columns of
\$data of the source track data objects.
}
\description{
Different track data objects from one segment list are bound by combining
the \$data columns of the track data object by columns.
}
\details{
All track data objects have to be track data of the same segment list.
Thus \$index and \$ftime values have to be identically for all track data
objects.  Track data objects are created by get_trackdata().  The number of
rows of the track data objects must match.
}
\examples{

   data(vowlax)
   
   #segment list vowlax - first segment only 
   vowlax[1,]
   
   #F0 track data object for vowlax - first segment only 
   vowlax.fund[1,]
   
   #rms track data object for vowlax - first segment only 
   vowlax.rms[1,]
      
   
   #now combine both track data objects
   fund.rms.lax = cbind(vowlax.fund, vowlax.rms)
   
   #the combined track data object - first segment only
   #The first column keeps vowlax.fund data, the second keeps vowlax.rms data 
   fund.rms.lax[1,]


}
\author{
Jonathan Harrington
}
\seealso{
\code{\link{cbind}}, \code{\link{rbind.trackdata}}
\code{\link{trackdata}} \code{\link{get_trackdata}}
}
\keyword{methods}

