% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_xml.R
\name{as_xml}
\alias{as_xml}
\title{Coerce an emld object into XML (EML's standard format)}
\usage{
as_xml(x, file = NULL, root = "eml", ns = "eml",
  schemaLocation = paste0(eml_ns(), "/ eml.xsd"))
}
\arguments{
\item{x}{an emld object}

\item{file}{optional path to write out to file.
Otherwise, defaults to NULL and will return an xml_document object.}

\item{root}{name for the root node; default to 'eml'}

\item{ns}{namespace abbreviation on root node, default 'eml'}

\item{schemaLocation}{default to set schemaLocation if not already defined in emld object}
}
\value{
a xml_document object. Or if a file path is provided, the metadata
is written out in XML file and the function returns \code{NULL} invisibly.
}
\description{
Coerce an emld object into XML (EML's standard format)
}
\details{
Unlike as_json, this function cannot rely on the existing
convention of serializing a list to xml, eg, as defined by xml2::as_xml_document()
Instead, this relies on a modified version, as_eml_document.  In addition
further steps must be taken when working with JSON-LD to deal with
different possible framings and namespaces from the JSON-LD context
element. Thus this \code{as_xml} function is particular to EML and \code{emld}
objects alone.
}
\examples{
f <- system.file("extdata/example.xml", package = "emld")
emld <- as_emld(f)
xml <- as_xml(emld)

## can also write directly to a file:
xml_file <- tempfile()
as_xml(emld, xml_file)
}
