% Generated by roxygen2 (4.0.1): do not edit by hand
\name{emil.fit.pamr}
\alias{emil.fit.pamr}
\title{Fit nearest shrunken centroids model.}
\usage{
emil.fit.pamr(x, y, error.fun, cv, threshold = NULL, ...,
  thres.fun = function(thr, err) median(thr[err == min(err)]),
  slim.fit = FALSE)
}
\arguments{
\item{x}{Dataset, numerical matrix with observations as rows.}

\item{y}{Class labels, factor.}

\item{error.fun}{Error function for tuning.}

\item{slim.fit}{Set to \code{TRUE} if you want to return the fitted
classifier but discard pamr's \code{cv.objects}, which can be large.
memory efficient. This means that the element \code{cv$cv.objects}
containing the cross-validated fits will be dropped from the returned
classifier.}

\item{cv}{Cross-validation scheme for shrinkage tuning. It should
be supplied on one of the following forms:
\itemize{
  \item{Resampling scheme produced with \code{\link{resample}}
    or \code{\link{resample.holdout}}.}
  \item{List with elements named \code{nrep} and \code{nfold}}
  \item{\code{NA}, \code{NULL} or \code{FALSE} to suppress shrinkage tuning.}
}}

\item{threshold}{Shrinkage thresholds to try (referred to as 'lambda' in the
literature). Chosen and tuned automatically by default, but must be given
by the user if not tuned (see the \code{cv} argument) if you wish to use
it with \code{\link{batch.model}}.}

\item{...}{Sent to \code{\link[pamr]{pamr.train}}.}

\item{thres.fun}{Threshold selection function. Note that it is not uncommon
that several thresholds will result in the same tuning error.}
}
\value{
Fitted pamr classifier.
}
\description{
Wrapped version of the \code{pamr} package implementation. Note that
this function uses internal cross-validation for determining the value
of the shrinkage threshold.
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{emil.predict.pamr}},
  \code{\link{emil.vimp.pamr}}, \code{\link{modeling.procedure}}
}

