% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustering.R
\name{clustering_genetic_algorithm}
\alias{clustering_genetic_algorithm}
\title{Clustering of the solutions of the genetic algorithm using the hclust algorithm}
\usage{
clustering_genetic_algorithm(
  genetic_results,
  ATCtree,
  dist.normalize = TRUE,
  umap_config = NULL
)
}
\arguments{
\item{genetic_results}{A list of cocktails in the form of integer vector}

\item{ATCtree}{ATC tree with upper bound of the DFS}

\item{dist.normalize}{Do we normalize the distance (so it belongs to [0;1])}

\item{umap_config}{The configuration to use in order to project the cocktails in a smaller space (umap::umap.defaults by default)}
}
\value{
A dataframe containing UMAP 1/2 the two coordinates of each cocktails in the plane as well as the cluster number of each cocktails
}
\description{
Clustering of the solutions of the genetic algorithm using the hclust algorithm
}
\examples{
\donttest{
 data("ATC_Tree_UpperBound_2024")

 results = GeneticAlgorithm(epochs = 10, nbIndividuals = 10, 
            ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy)

 hclust_genetic_solution(genetic_results = results,
                 ATCtree = ATC_Tree_UpperBound_2024)
}
}
