% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{is_comb_element_of}
\alias{is_comb_element_of}
\title{Is drug combination element of given vector?}
\usage{
is_comb_element_of(drug.comb, comb.vector)
}
\arguments{
\item{drug.comb}{a string in the form \emph{A-B} (no spaces between the names
and the hyphen '-')}

\item{comb.vector}{a character vector of drug combinations, each one in the
form \emph{drugname.1-drugname.2}}
}
\value{
logical, depending if the drug combination is element of the given
vector or not.
}
\description{
Use this function to determine if a drug combination is part of a vector of
other drug combinations. We take care only of pair-wise drug combinations and
an internal check is done for alternative drug names, e.g. we check if
\emph{A-B} combination is included, but also for \emph{B-A}.
}
\examples{
# TRUE
is_comb_element_of("A-B", c("E-F", "A-B"))
is_comb_element_of("B-A", c("E-F", "A-B"))

# FALSE
is_comb_element_of("A-B", c("E-F", "A-D"))
is_comb_element_of("A-B", c())

}
