% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{get_avg_activity_diff_mat_based_on_specific_synergy_prediction}
\alias{get_avg_activity_diff_mat_based_on_specific_synergy_prediction}
\title{Get average activity difference matrix based on specific synergy prediction}
\usage{
get_avg_activity_diff_mat_based_on_specific_synergy_prediction(
  model.predictions,
  models.stable.state,
  predicted.synergies,
  penalty = 0
)
}
\arguments{
\item{model.predictions}{a \code{data.frame} object with rows the models and
columns the drug combinations. Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models)}

\item{models.stable.state}{a \code{data.frame} (nxm) with n models and m nodes. The row
names specify the models' names whereas the column names specify the network nodes
(gene, proteins, etc.). Possible values for each \emph{model-node element}
can be between \emph{0} (inactive node) and \emph{1} (active node) inclusive.}

\item{predicted.synergies}{a character vector of the synergies (drug
combination names) that were predicted by \strong{at least one} of the models
in the dataset. It must be a subset of the column names (the drug combinations)
of the \code{model.predictions} object.}

\item{penalty}{value between 0 and 1 (inclusive). A value of 0 means no
penalty and a value of 1 is the strickest possible penalty. Default value is 0.
This penalty is used as part of a weighted term to the difference in a value of
interest (e.g. activity or link operator difference) between two group of
models, to account for the difference in the number of models from each
respective model group.}
}
\value{
a matrix whose rows are \strong{vectors of
average node activity state differences} between two groups of models where
the classification for each individual row was based on the prediction or not
of a specific synergistic drug combination.
The row names are the predicted synergies, one per row, while the columns
represent the network's node names. Values are in the [-1,1] interval.
}
\description{
This function uses the \code{\link{get_avg_activity_diff_based_on_specific_synergy_prediction}}
function on a vector of drug combinations that were observed as synergistic
(e.g. by experiments) but also found as such by at least one of the models
(these drug combinations are the \code{predicted.synergies}).
}
\seealso{
\code{\link{get_vector_diff}}

Other average data difference functions: 
\code{\link{get_avg_activity_diff_based_on_mcc_clustering}()},
\code{\link{get_avg_activity_diff_based_on_specific_synergy_prediction}()},
\code{\link{get_avg_activity_diff_based_on_synergy_set_cmp}()},
\code{\link{get_avg_activity_diff_based_on_tp_predictions}()},
\code{\link{get_avg_activity_diff_mat_based_on_mcc_clustering}()},
\code{\link{get_avg_activity_diff_mat_based_on_tp_predictions}()},
\code{\link{get_avg_link_operator_diff_based_on_synergy_set_cmp}()},
\code{\link{get_avg_link_operator_diff_mat_based_on_mcc_clustering}()},
\code{\link{get_avg_link_operator_diff_mat_based_on_specific_synergy_prediction}()},
\code{\link{get_avg_link_operator_diff_mat_based_on_tp_predictions}()}
}
\concept{average data difference functions}
