% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.logLike.R
\name{make.logLike}
\alias{make.logLike}
\title{Construct a log-likelihood function in the parameters b, for the given link family.}
\usage{
make.logLike(x, y, weight = c(1), class_probs = c(1),
  family = poisson)
}
\arguments{
\item{x}{An \emph{n}-by-\emph{p} design matrix.}

\item{y}{A vector of observation of length \emph{n}.}

\item{weight}{A \emph{n} length vector of observation weight terms.  This is currently designed to be either the exposure for a Poisson model or the number of trials for a Logistic model.}

\item{class_probs}{An \emph{n} length vector  of probabilities for the proposed model.}

\item{family}{The GLM family being considered.}
}
\value{
A model likelihood function.  Expects one argument which is a *p* length vector of parameters.
}
\description{
Construct a log-likelihood function in the parameters b, for the given link family.
}
\examples{
x <- model.matrix(~ factor(wool) + factor(tension), warpbreaks)
y <- warpbreaks$breaks

make.logLike(x, y)

}
