% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dprob.list.R
\name{make.dbinom}
\alias{make.dbinom}
\title{Build a Binomial log likelihood}
\usage{
make.dbinom(x, y, linkinv = binomial()$linkinv, weight = 1,
  log = FALSE)
}
\arguments{
\item{x}{An \emph{n}-by-\emph{p} design matrix.}

\item{y}{A vector of observation of length \emph{n}.}

\item{linkinv}{Inverse link function desired}

\item{weight}{A \emph{n} length vector of observation weight terms.  This is currently designed to be either the exposure for a Poisson model or the number of trials for a Logistic model.}

\item{log}{Boolean flag.  If TRUE returns the log dist.}
}
\value{
A function to  calculate (log) likelihood for a given set of parameters under a Binomial model.
}
\description{
Build a Binomial log likelihood
}
\examples{
x <- model.matrix(~ factor(wool) + factor(tension), warpbreaks)
y <- warpbreaks$breaks
make.dbinom(x, y)

}
