% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtree.R
\docType{class}
\name{dirichlet_tree}
\alias{dirichlet_tree}
\title{Create a Dirichlet-tree for modelling ranked ballots}
\format{
An \code{\link{R6Class}} generator object.
}
\description{
A \code{dirichlet_tree} object represents a Dirichlet-tree distribution
on ballots. By specifying the tree structure for the ranked ballots,
the Dirichlet-tree is initialized with the same prior structure described by
\insertCite{dtree_evoteid;textual}{elections.dtree}. There are
methods provided for observing data (to obtain a posterior distribution)
along with methods to sample election outcomes and sets of ballots from
the posterior predictive distribution.
}
\examples{

## ------------------------------------------------
## Method `dirichlet_tree$new`
## ------------------------------------------------

dtree <- dirichlet_tree$new(candidates = LETTERS, a0 = 1., min_depth = 1)


## ------------------------------------------------
## Method `dirichlet_tree$update`
## ------------------------------------------------

dirichlet_tree$new(
  candidates = LETTERS
)$update(
  ranked_ballots(c("A", "B", "C"))
)


## ------------------------------------------------
## Method `dirichlet_tree$reset`
## ------------------------------------------------

dirichlet_tree$new(
  candidates = LETTERS
)$update(
  ranked_ballots(c("A", "B", "C"))
)$reset()


## ------------------------------------------------
## Method `dirichlet_tree$sample_posterior`
## ------------------------------------------------

dirichlet_tree$new(
  candidates = LETTERS,
  a0 = 1.,
  min_depth = 3,
  max_depth = 6,
  vd = FALSE
)$update(
  ranked_ballots(c("A","B","C"))
)$sample_posterior(
  n_elections = 10,
  n_ballots = 10
)


## ------------------------------------------------
## Method `dirichlet_tree$sample_predictive`
## ------------------------------------------------

dirichlet_tree$new(
  candidates = LETTERS,
  a0 = 1.,
  min_depth = 3,
  max_depth = 6,
  vd = FALSE
)$update(
  ranked_ballots(c("A","B","C"))
)$sample_predictive(
  n_ballots = 10
)

}
\references{
\insertRef{dtree_eis}{elections.dtree}.

\insertRef{dtree_evoteid}{elections.dtree}.
}
\keyword{ballot}
\keyword{dirichlet}
\keyword{dirichlet-tree}
\keyword{election}
\keyword{irv}
\keyword{tree}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{a0}}{Gets or sets the \code{a0} parameter for the Dirichlet-tree.}

\item{\code{min_depth}}{Gets or sets the \code{min_depth} parameter for the Dirichlet-tree.}

\item{\code{max_depth}}{Gets or sets the \code{max_depth} parameter for the
Dirichlet-tree.}

\item{\code{vd}}{Gets or sets the \code{vd} parameter for the Dirichlet-tree.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-dirichlet_tree-new}{\code{dirichlet_tree$new()}}
\item \href{#method-dirichlet_tree-print}{\code{dirichlet_tree$print()}}
\item \href{#method-dirichlet_tree-update}{\code{dirichlet_tree$update()}}
\item \href{#method-dirichlet_tree-reset}{\code{dirichlet_tree$reset()}}
\item \href{#method-dirichlet_tree-sample_posterior}{\code{dirichlet_tree$sample_posterior()}}
\item \href{#method-dirichlet_tree-sample_predictive}{\code{dirichlet_tree$sample_predictive()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dirichlet_tree-new"></a>}}
\if{latex}{\out{\hypertarget{method-dirichlet_tree-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{dirichlet_tree} prior distribution with the specified
tree structure. See \insertCite{dtree_evoteid;textual}{elections.dtree}
for further details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dirichlet_tree$new(
  candidates,
  min_depth = 0,
  max_depth = length(candidates) - 1,
  a0 = 1,
  vd = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{candidates}}{A character vector, with each element (must be unique) representing a
single candidate.}

\item{\code{min_depth}}{The minimum number of candidates which must be specified for a valid
ballot in the election.}

\item{\code{max_depth}}{The maximum number of candidates which can be specified for a valid
ballot in the election.}

\item{\code{a0}}{The prior parameter for the distribution.}

\item{\code{vd}}{A flag which, when \code{TRUE}, employs a parameter structure which
reduces to a regular Dirichlet distribution as described by
\insertCite{dtree_evoteid;textual}{elections.dtree}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{dirichlet_tree} prior.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dtree <- dirichlet_tree$new(candidates = LETTERS, a0 = 1., min_depth = 1)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dirichlet_tree-print"></a>}}
\if{latex}{\out{\hypertarget{method-dirichlet_tree-print}{}}}
\subsection{Method \code{print()}}{
\code{print} shows some details of the distribution and its parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dirichlet_tree$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{dirichlet_tree} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dirichlet_tree-update"></a>}}
\if{latex}{\out{\hypertarget{method-dirichlet_tree-update}{}}}
\subsection{Method \code{update()}}{
Updates the \code{dirichlet_tree} object with observations of ballots.
This updates the parameter structure of the tree to yield the posterior
Dirichlet-tree, as described in
\insertCite{dtree_evoteid;textual}{elections.dtree}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dirichlet_tree$update(ballots)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ballots}}{A set of ballots to observe - must be of class \code{ranked_ballots}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{dirichlet_tree} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dirichlet_tree$new(
  candidates = LETTERS
)$update(
  ranked_ballots(c("A", "B", "C"))
)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dirichlet_tree-reset"></a>}}
\if{latex}{\out{\hypertarget{method-dirichlet_tree-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the \code{dirichlet_tree} observations to revert the
parameter structure back to the originally specified prior.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dirichlet_tree$reset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{dirichlet_tree} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dirichlet_tree$new(
  candidates = LETTERS
)$update(
  ranked_ballots(c("A", "B", "C"))
)$reset()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dirichlet_tree-sample_posterior"></a>}}
\if{latex}{\out{\hypertarget{method-dirichlet_tree-sample_posterior}{}}}
\subsection{Method \code{sample_posterior()}}{
Draws sets of ballots from independent realizations of the Dirichlet-tree
posterior, then determines the probability for each candidate being
elected by aggregating the results of the social choice function. See
\insertCite{dtree_evoteid;textual}{elections.dtree} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dirichlet_tree$sample_posterior(
  n_elections,
  n_ballots,
  n_winners = 1,
  replace = FALSE,
  n_threads = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_elections}}{An integer representing the number of elections to generate. A higher
number yields higher precision in the output probabilities.}

\item{\code{n_ballots}}{An integer representing the total number of ballots cast in the election.}

\item{\code{n_winners}}{The number of candidates elected in each election.}

\item{\code{replace}}{A boolean indicating whether or not we should replace our sample in the
monte-carlo step, drawing the full set of election ballots from the posterior}

\item{\code{n_threads}}{The maximum number of threads for the process. The default value of
\code{NULL} will default to 2 threads. \code{Inf} will default to the maximum
available, and any value greater than or equal to the maximum available will
result in the maximum available.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector containing the probabilities for each candidate
being elected.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dirichlet_tree$new(
  candidates = LETTERS,
  a0 = 1.,
  min_depth = 3,
  max_depth = 6,
  vd = FALSE
)$update(
  ranked_ballots(c("A","B","C"))
)$sample_posterior(
  n_elections = 10,
  n_ballots = 10
)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dirichlet_tree-sample_predictive"></a>}}
\if{latex}{\out{\hypertarget{method-dirichlet_tree-sample_predictive}{}}}
\subsection{Method \code{sample_predictive()}}{
\code{sample_predictive} draws ballots from a multinomial distribution
with ballot probabilities obtained from a single realization of the
Dirichlet-tree posterior on the ranked ballots. See
\insertCite{dtree_evoteid;textual}{elections.dtree} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dirichlet_tree$sample_predictive(n_ballots)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_ballots}}{An integer representing the total number of ballots cast in the election.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{ranked_ballots} object containing \code{n_ballots}
ballots drawn from a single realisation of the posterior Dirichlet-tree.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dirichlet_tree$new(
  candidates = LETTERS,
  a0 = 1.,
  min_depth = 3,
  max_depth = 6,
  vd = FALSE
)$update(
  ranked_ballots(c("A","B","C"))
)$sample_predictive(
  n_ballots = 10
)

}
\if{html}{\out{</div>}}

}

}
}
