% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard.R
\name{biscale}
\alias{biscale}
\title{Data standardization}
\usage{
biscale(x, thresh.sd = 1e-05, maxit.sd = 100, control = list(...), ...)
}
\arguments{
\item{x}{an \eqn{m} by \eqn{n} matrix possibly with \code{NA}s.}

\item{thresh.sd}{convergence threshold, measured as the relative change in the Frobenius norm between two successive estimates.}

\item{maxit.sd}{maximum number of iterations.}

\item{control}{a list of parameters that control details of standard procedure. See \link{biscale.control}.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
A list is returned
\item{\code{x.st}}{The matrix after standardization.}
\item{\code{alpha}}{The row mean after iterative process.}
\item{\code{beta}}{The column mean after iterative process.}
\item{\code{tau}}{The row standard deviation after iterative process.}
\item{\code{gamma}}{The column standard deviation after iterative process.}
}
\description{
Standardize a matrix rows and/or columns to have zero mean or unit variance
}
\examples{
################# Quick Start #################
m <- 100
n <- 100
r <- 10
x_na <- incomplete.generator(m, n, r)

###### Standardize both mean and variance
xs <- biscale(x_na)

###### Only standardize mean ######
xs_mean <- biscale(x_na, row.mean = TRUE, col.mean = TRUE)

###### Only standardize variance ######
xs_std <- biscale(x_na, row.std = TRUE, col.std = TRUE)
}
\references{
Hastie, Trevor, Rahul Mazumder, Jason D. Lee, and Reza Zadeh. Matrix completion and low-rank SVD via fast alternating least squares. The Journal of Machine Learning Research 16, no. 1 (2015): 3367-3402.
}
