% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_interactive.R
\name{map_interactive}
\alias{map_interactive}
\title{This function allows the user to plot an interactive map
of the voter longitude and latitude points.}
\usage{
map_interactive(
  voter_file,
  voter_id = "registration_number",
  f_name = "first_name",
  l_name = "last_name",
  fips_code = "county_code",
  latitude = "lat",
  longitude = "lon"
)
}
\arguments{
\item{voter_file}{a dataframe with a geometry column for
latitude and longitudes created after original voter file
was processed with a select geocoder.}

\item{voter_id}{a unique identifier on the voter registration
file.}

\item{f_name}{the column with first names of voters.}

\item{l_name}{the column with last names of voters.}

\item{fips_code}{the column with the fips code for the designated
geograhic.
unit of interest (i.e. state, county, block, tract).}

\item{latitude}{the column of the of the voter_file that
corresponds to #' latitude coordinates. This is optional
and a parameter only used if the dataframe used does not
have a concatenated geometry column with a
"c(latitude, longitude)" structure as in the output from the
geocoder censusxy}

\item{longitude}{the column of the of the voter_file that
corresponds to #' longitude coordinates. This is optional
and a parameter only used if the dataframe used does not
have a concatenated geometry column with a
"c(latitude, longitude)" structure as in the output from the
geocoder censusxy}
}
\description{
This function allows the user to plot an interactive map
of the voter longitude and latitude points.
}
\author{
Loren Collingwood <loren.collingwood@ucr.edu>

Juandalyn Burke <jcburke@uw.edu>
}
