% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ego_constraint.R
\name{ego_constraint}
\alias{ego_constraint}
\title{Calculate Burt constraint for the egos of ego-centered networks}
\usage{
ego_constraint(object, weights = NULL, ego.alter.weights = weights)
}
\arguments{
\item{object}{An \code{egor} object.}

\item{weights}{\code{Character}, naming the alter-alter tie weight variable.}

\item{ego.alter.weights}{\code{Character}, naming the ego-alter weight tie weight
variable. This defaults to the same value as \code{weights}, only specify if the
name of the ego.alter.weights is different from \code{weights}.}
}
\value{
\code{Numeric} vector with a constraint value for each ego.
}
\description{
This calculates Burt's \emph{network constraint} for all egos in an egor object.
It iterates over each network and applies \link[igraph:constraint]{igraph::constraint}. A
weight variable can be specified.
}
\details{
The calculation of weighted network constraint only works, if
the alter-alter tie weights are complemented by a alter level variable
specifying the same weight for the ego-alter ties.
}
\examples{
data(egor32)
ego_constraint(egor32)
}
\references{
Burt, R. (2004). Structural holes and good ideas. \emph{American Journal of Sociology}, (110), 349–399.
}
