% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfunctions.R
\name{plot.eefAnalytics}
\alias{plot.eefAnalytics}
\title{A plot method for the an eefAnalytics S3 object obtained  from the eefAnalytic package.}
\usage{
\method{plot}{eefAnalytics}(x, group = NULL, ...)
}
\arguments{
\item{x}{an output object from the eefAnalytics package.}

\item{group}{a value indicating which intervention to plot.
This must not be greater than the number of intervention excluding the control group.
For a two arm trial, the maximum value is 1 and a maximum value of 2 for three arm trial.}

\item{...}{arguments passed to \code{\link[graphics]{plot.default}}}
}
\value{
Returns relevant plots for each model.
}
\description{
plots different figures based on output from eefAnalytics package.
}
\details{
Plot produces graphical visualisation depending on which model is fitted:
\itemize{
\item For \code{srtFREQ()}, plot can only be used when \code{nBoot} or \code{nPerm} is specified to visualise the distribution of boostrapped or permutated values. 
\item For \code{crtFREQ()} or \code{mstFREQ}, plot shows the distribution of random intercepts when \code{group=NULL}. 
It produces histogram of permutated or bootstrapped values when \code{group} is specified and either \code{nBoot} or \code{nPerm} is also specified. 
\item For \code{mlmBayes()}, plot produces the distrbution of random intercepts when \code{group = NULL}. 
It produces the probability of effect size to be greater than a pre-specified threshold when group is specified. 
\item Lastly, plot produces forest plots to compare CACE estimated for different level of compliance when \code{caceSRTBoot()} or 
\code{caceCRTBoot()} or \code{caceMSTBoot()} is used.
}
}
\examples{
if(interactive()){

#### read data
data(mstData)
data(crtData)


###############
##### SRT #####
###############

##### Bootstrapped

outputSRTBoot <- srtFREQ(Posttest~ Intervention + Prettest,
                         intervention = "Intervention",nBoot=1000, data = mstData)
plot(outputSRTBoot,group=1)

##### Permutation
outputSRTPerm <- srtFREQ(Posttest~ Intervention + Prettest,
                         intervention = "Intervention",nPerm=1000, data = mstData)

plot(outputSRTPerm,group=1)


###############
##### MST #####
###############


#### Random intercepts
outputMST <- mstFREQ(Posttest~ Intervention + Prettest, 
                     random = "School", intervention = "Intervention", data = mstData)
plot(outputMST)


#### Bootstrapped
outputMSTBoot <- mstFREQ(Posttest~ Intervention + Prettest, 
                         random = "School", intervention = "Intervention", 
                         nBoot = 1000, data = mstData)

plot(outputMSTBoot)
plot(outputMSTBoot,group=1)

#### Permutation
outputMSTPerm <- mstFREQ(Posttest~ Intervention + Prettest, 
                         random = "School", intervention = "Intervention",
                         nPerm = 1000, data = mstData)
plot(outputMSTPerm)
plot(outputMSTPerm,group=1)


####################
##### Bayesian #####
####################


outputMSTbayes <- mlmBayes(Posttest~ Intervention + Prettest, 
                           random = "School", intervention = "Intervention",
                           nSim = 10000, data = mstData)

## Random intercepts
plot(outputMSTbayes)

## Probability of effect size greater than a precified threshold
plot(outputMSTbayes,group=1)

###############
##### CRT #####
###############

#### Random intercepts
outputCRT <- crtFREQ(Posttest~ Intervention + Prettest, random = "School", 
                     intervention = "Intervention", data = crtData)
plot(outputCRT)


## Bootstrapped
outputCRTBoot <- crtFREQ(Posttest~ Intervention + Prettest, random = "School", 
                         intervention = "Intervention", nBoot = 1000, data = crtData)

plot(outputCRTBoot,group=1)


##Permutation
outputCRTPerm <- crtFREQ(Posttest~ Intervention + Prettest, random = "School", 
                         intervention = "Intervention", nPerm = 1000, data = crtData)

plot(outputCRTPerm,group=1)


## Bayesain
outputCRTbayes <- mlmBayes(Posttest~ Intervention + Prettest, random = "School", 
                           intervention = "Intervention", nSim = 10000, data = crtData)

plot(outputCRTbayes,group=1)



################
##### CACE #####
################

outputSRTCace <- caceSRTBoot(Posttest~ Intervention + Prettest,
                             intervention = "Intervention",compliance="Percentage_Attendance",
                             nBoot=1000, data = mstData) 
plot(outputSRTCace)



outputMSTCace <- caceMSTBoot(Posttest~ Intervention + Prettest,random="School",
                             intervention = "Intervention",compliance="Percentage_Attendance",
                             nBoot=1000, data = mstData) 
plot(outputMSTCace)


outputCRTCace <- caceCRTBoot(Posttest~ Intervention + Prettest,random="School",
                             intervention = "Intervention",compliance="Percentage_Attendance",
                             nBoot=1000, data = crtData) 
plot(outputCRTCace)
}
}

