% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colamdR.R
\name{colamdR}
\alias{colamdR}
\title{Column Approximate Minimum Degree Permutation}
\usage{
colamdR(M)
}
\arguments{
\item{M}{A matrix to be permuted.}
}
\value{
A vector containing the column minimum degree permutation of the matrix M.
}
\description{
\code{colamdR} returns the column approximate minimum degree permutation of a 
sparse matrix S. The permutation of S, S[,p], will result in LU factors sparser
than S.
}
\details{
This is an implementation of the colamd function available in SuiteSparse, and also implemented in Matlab.
}
\examples{
M <- matrix(c(1,1,0,0,1,0,0,1,0,1,1,1,1,1,0,0,1,0,1,0), ncol=4)
p <- colamdR(M)
M[,p]

}
\references{
The authors of the code for "colamd" are Stefan I. Larimore and Timothy A. Davis (davis@cise.ufl.edu), University of Florida.
}
